/**
 */
Ext.define('Academia.utilities.ux.CustomComboBox', {
    extend : 'Ext.form.field.ComboBox',
	alias : 'widget.customcombobox', 
	maskRe: /[^%]/,
	triggerCls: 'ph-caret-down',
	constructor: function (args) {
		var me = this,
		displayField = args.displayField ;

		args.tpl = new Ext.XTemplate(
				'<tpl for=".">',
				'<tpl if="xindex%2==0"><div class="x-boundlist-item combo-even"></tpl><tpl  if="xindex%2==1"><div class="x-boundlist-item combo-odd"></tpl> {' + displayField + '} </div>',
				'</tpl>'
		);
		
		me.callParent(arguments);
	},
	listeners: {
		change: function(obj, newValue, oldValue, opt){
			if(newValue && !Ext.isObject(newValue) && !Ext.isNumber(newValue) && !Ext.isBoolean(newValue) && newValue.match(/%/)){
				obj.setValue(oldValue);
			}
		  
		},
		/**
		 * add this event if user select record from dropdown and then start typing and click out side of combo
		 * then combo field is showing invalid but combo have proper value and combo config forceSelection should be true
		 */
		blur:function(cmp){
			if(!cmp.allowBlank && cmp.isValid()){
				cmp.clearInvalid();
				cmp.up('form') && cmp.up('form').isValid();
				cmp.up('form') && cmp.up('form').getForm().clearInvalid();
			}
		}
	}
	
});
