Ext.define('Academia.utilities.ux.PageSize', {
	extend: 'Ext.AbstractPlugin',
	alias : 'plugin.pagesize',
	pluginId : 'pagesize',
	alternateClassName : [ 'PageSize' ],
	/**
	 * @cfg {String} beforeText Text to display before the comboBox
	 */
	beforeText : getCommonTranslation('PAGINATIONBARBEFORETEXT'),

	/**
	 * @cfg {String} afterText Text to display after the comboBox
	 */
	afterText : getCommonTranslation('PAGINATIONBARAFTERTEXT'),
	/**
	 * @cfg {Mixed} addBefore Toolbar item(s) to add before the PageSizer
	 */
	addBefore : '-',

	/**
	 * @cfg {Mixed} addAfter Toolbar item(s) to be added after the PageSizer
	 */
	addAfter : null,

	/**
	 * @cfg {Array} variations Variations used for determining pageSize options
	 */
	variations : [ 5, 10, 20, 50, 100 ],

	init : function(pagingToolbar) {
		this.pagingToolbar = pagingToolbar;
		this.pagingToolbar.on('render', this.onRender, this);
	},

	onRender : function(view) {
		
		var grid = view.up('grid').itemId;
		var store = Ext.create('Ext.data.Store', {
			autoLoad : true,
			fields : [ 'id','pageSize' ],
			data :  (grid=='vouchermodelist')?  PAGE_ROW_SIZE_MANAGE_VOUCHER : PAGE_ROW_SIZE
		});
		this.combo = Ext.create('Ext.form.field.ComboBox', {
			store : store,
			name: 'pageSize',
			clearTrigger : false,
			displayField : 'pageSize',
			valueField : 'id',
			editable : false,
			queryMode : 'local',
			triggerAction : 'all',
			width : (grid=='vouchermodelist')?  66 : 60
		});
		this.combo.on('select', this.changePageSize, this);
		this.setPageSize();

		if (this.addBefore) {
			this.pagingToolbar.insert(11, this.addBefore);
		}
		if (this.beforeText) {
			this.pagingToolbar.insert(12, this.beforeText);
		}
		this.pagingToolbar.insert(13, this.combo);
		if (this.afterText) {
			this.pagingToolbar.insert(14, this.afterText);
		}
		if (this.addAfter) {
			this.pagingToolbar.insert(15, this.addAfter);
		}
		// remove space 
		this.pagingToolbar.remove(15);
		if(Ext.isFunction(this.pagingToolbar.hideComponent)){
			this.pagingToolbar.hideComponent();
		}
	},

	changePageSize : function() {
		var pagingStore=this.pagingToolbar.store;
		if( this.combo.getValue()!= -1){
			pagingStore.pageSize = this.combo.getValue();
		}else{
			pagingStore.pageSize = 500;
		}
		pagingStore.proxy.extraParams.limit = pagingStore.pageSize; //add line for remove pagination issue on grid
		pagingStore.currentPage = 1;
		this.pagingToolbar.doRefresh();
	},
	
	/**
	 * Default value 10
	 */
	setPageSize : function(){
		var pagingStore=this.pagingToolbar.store;
		if(isNullOrEmpty(pagingStore.pageSize)){
			pagingStore.pageSize = CONSTANTS.DEFAULT_PAGESIZE;
		}		
		this.combo.setValue(pagingStore.pageSize);
	}
	
	
});
