/*
 * author @Raghavendra.Soni
 *
 */
Ext.define('Academia.view.DMSView.DmsAddUserWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.dmsadduserwindow',
	title : getDMSTranslation('DMS_ADD_USER'),
	autoScroll : true,
	maxHeight : 900,
	maxWidth: 1000,
	modal : true,
	closeAction: 'destroy',
	items : [ {
		xtype : 'form',
		columns : 2,
		defaults : {
			width: 536,
			labelWidth: 150
		},
		plugins : "formlabelrequired",
		items : [{
			xtype: 'hidden',
			itemId: 'siteName'
		},{
			xtype: 'hidden',
			itemId: 'siteId'
		},{
			xtype : 'combobox',
			name : 'role',
			itemId:'dmsrole',
			allowBlank : false,
			fieldLabel : getDMSTranslation('ROLE'),
			store: new Ext.data.ArrayStore({
				id: 0,
				fields: [
					'roleDisplayName',
					'role'
				],
				data: [['Manager','SiteManager'], ['Collaborator','SiteCollaborator'],['Contributor','SiteContributor'], ['Consumer','SiteConsumer']]  // data is local
			}),
			valueField: 'role',
			displayField: 'roleDisplayName',
			triggerAction: 'all',
			editable: false
		}, {
			xtype: 'customcombobox',
			name: 'userId',
			itemId:'userItemId',
			fieldLabel: getDMSTranslation('USER_NAME'),
            store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyCombo'),
            displayField : 'value',
			valueField : 'id',
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank: false,
			emptyText: getDMSTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getDMSTranslation('SEARCHING'),
				emptyText: getDMSTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}, {
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getDMSTranslation('SAVE'),
				itemId : 'dmsAddUserSubmitButtonId',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'dmsAddUserCancelButtonId',
				text : getDMSTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	} ]

});