/**
 * 
 */

Ext.define('Academia.view.DMSView.DmsFileGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.dmsfilegrid',
	store:'',
	title: getCommonTranslation('STUDENT_FEE_REPORT'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : '',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[
	         {
	        	 header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
	        	 dataIndex : 'studentID',
	        	 flex:1,
	        	 sortable:true,
	        	 renderer:function(value){
	        		 return '<a href=#>'+value+'</a>'
	        	 },
	        	 summaryRenderer: function(value, summaryData, dataIndex) {
	                 return getFeeAndPaymentCommonTranslation('TOTAL');
	             }
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
	        	 dataIndex : 'printName',
	        	 flex:1
	         },{
        		header : getFeeAndPaymentCommonTranslation('STUDENT_FIRST_NAME'),
        		dataIndex : 'personFirstName',
        		flex:1,
        		hidden:true
        	},{
        		header : getFeeAndPaymentCommonTranslation('STUDENT_MIDDLE_NAME'),
        		dataIndex : 'personMiddleName',
        		flex:1,
        		hidden:true
        	},{
        		header : getFeeAndPaymentCommonTranslation('STUDENT_LAST_NAME'),
        		dataIndex : 'personLastName',
        		flex:1,
        		hidden:true
        	},{
	        	 header : getFeeAndPaymentCommonTranslation('FATHER_NAME'),
	        	 dataIndex : 'fatherName',
	        	 flex:1
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('PROGRAM'),
	        	 dataIndex : 'programName',
	        	 flex:1
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('BATCH'),
	        	 dataIndex : 'batchName',
	        	 flex:1
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
	        	 dataIndex : 'seatName',
	        	 flex:1
	         },{
	     		header:getFeeAndPaymentCommonTranslation('TOTAL_AMOUNT'),
	    		dataIndex:'feeAmount',
	    		flex : 1,
	    		hidden: true,
	    		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	    		summaryType: 'sum',
	    		renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				return currencyRenderer(value,record.get("currencyId"));
	    			}
	    		}
	    	},{
	    		header:getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
	    		dataIndex:'discountAmount',
	    		flex : 1,
	    		hidden: true,
	    		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	    		summaryType: 'sum',
	    		renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				return currencyRenderer(value,record.get("currencyId"));
	    			}
	    		}
	    	},{
	        	 header : getFeeAndPaymentCommonTranslation('TOTAL_BILL'),
	        	 dataIndex : 'totalBillAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 /*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	        		 return  value;
	        	 },*/
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
	     			if(!isNullOrEmpty(value)){
	     				return currencyRenderer(value,record.get("currencyId"));
	     			}
	     		},
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('TOTAL_RECEIPT_AMOUNT'),
	        	 dataIndex : 'totalReceiptAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	/* summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	        		 return  value;
	        	 },*/
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
	     			if(!isNullOrEmpty(value)){
	     				return currencyRenderer(value,record.get("currencyId"));
	     			}
	     		},
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('TOTAL_RECEIPT_AMOUNT_SETTLED'),
	        	 dataIndex : 'totalNetCollectionAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 hidden:true,
	        	 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	/* summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	        		 return  value;
	        	 },*/
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
	     			if(!isNullOrEmpty(value)){
	     				return currencyRenderer(value,record.get("currencyId"));
	     			}
	     		},
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('TOTAL_OUTSTANDING'),
	        	 dataIndex : 'totalOutstandingAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	/* summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	        		 return  value;
	        	 },*/
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
	     			if(!isNullOrEmpty(value)){
	     				return currencyRenderer(value,record.get("currencyId"));
	     			}
	     		},
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('TOTAL_PAYMENT'),
	        	 dataIndex : 'totalPaymentAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 /*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	        		 return  value;
	        	 },*/
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
	     			if(!isNullOrEmpty(value)){
	     				return currencyRenderer(value,record.get("currencyId"));
	     			}
	     		},
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('NET_OUTSTANDING_AMOUNT'),
	        	 dataIndex : 'netOutStandingAmount',
	        	 flex:1.8,
	        	 summaryType: 'sum',
	        	 align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	 /*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	        		 return  value;
	        	 },*/
	        	 renderer:function(value, metaData, record, row, col, store, gridView){
	     			if(!isNullOrEmpty(value)){
	     				return currencyRenderer(value,record.get("currencyId"));
	     			}
	     		},
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('ADDRESS'),
	        	 dataIndex : 'address',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('EMAIL_ID'),
	        	 dataIndex : 'emailId',
	        	 flex:1,
	        	 hidden:true
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('MOBILE_NUMBER'),
	        	 dataIndex : 'mobileNo',
	        	 flex:1,
	        	 hidden:true
	         }]

}
);
