Ext.define('Academia.view.DMSView.SiteDocumentUpdateWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.sitedocumentupdatewindow',
	title:getDMSTranslation('UPDATE_FILE'),
	frame: true,
	autoScroll:false,
	modal:true,
	method: 'POST',
	height: 390,
	width: 510,
	items:[{
		xtype: 'form',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			width:440,
			height: 270,
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype     : 'component',
				width: '100%',
			    autoEl    : {
			      html : '<form enctype="multipart/form-data" method="post">'+
			      			'<div class="form-group file-area">'+
			      				'<input type="file" name="siteDocuments[]" required="required" accept="*/*" />'+
			      				'<div class="file-dummy">'+
			      					'<div class="success">Your file is selected.</div>'+
			      					'<div class="default" style="font-weight:bold;">'+getDMSTranslation('SITE_DRAG_DOCUMENT')+'</div>'+
			      					'</div>'+
			      				'</div>'+
			      			'</form>'
			    },
			    listeners : {
			        el : {
			            delegate : 'input',
			            change: function(component, fileField, eOpts) {
			            	//-- check selected files and extensions
			            	if(fileField.checkValidity()){
			            		//--enable file upload button
		            			Ext.ComponentQuery.query('sitedocumentupdatewindow')[0].down('#submitImageBtnWin').setDisabled(false);
			            	}
			            	else if(fileField.files.length==0){
			            		fileField.value='';
		            			Ext.ComponentQuery.query('sitedocumentupdatewindow')[0].down('#submitImageBtnWin').setDisabled(true);
			            	}
			            	else {
			            		fileField.value='';
			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_FORMAT'));
		            			Ext.ComponentQuery.query('sitedocumentupdatewindow')[0].down('#submitImageBtnWin').setDisabled(true);
			            	}
			            }
			        }
			    }
			},{
				xtype:'fieldset',
				title: getDMSTranslation('NEW_VERSION_INFORMATION'),
				width: 440,
				defaults: {
					labelAlign: 'left',
					width:420
				},
				items:[
					{
		                xtype: 'radiogroup',
		                itemId: 'versionInfo',
		                columns: 2,
		                vertical: false,
		                layout: {
		                    type: 'hbox'
		                },
		                fieldLabel: getDMSTranslation('THIS_VERSION_HAS'),
		                items: [{
		                    boxLabel: getDMSTranslation('MINOR_CHANGES')+' (xx.xx)',
		                    name: 'versionInfo',
		                    inputValue: 'minor',
		                    checked: true
		                }, {
		                    boxLabel: getDMSTranslation('MAJOR_CHANGES')+' (xx.xx)',
		                    name: 'versionInfo',
		                    inputValue: 'major'
		                }]
		            },
		            {
		            	xtype: 'textarea',
		            	itemId: 'commentTextareaItemId',
		            	fieldLabel: getDMSTranslation('COMMENTS')
		            }
				]
			}
			]},{ 	
				xtype:'fieldcontainer',
				width:'auto',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					itemId: 'submitImageBtnWin',
					ui: 'CustomBtnSubmit',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'cancelImageBtnWin',
					scale: CONSTANTS.BUTTONSIZE
				}]
		}]
	}]
});