Ext.define('Academia.view.DMSView.WorkflowPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.workflowpanel',
    margin: 0,
    autoScroll: true,
    frame: true,
    border: true,
    height: 580,
    items:[{
    	xtype : 'combobox',
    	name : 'selectWorkflow',
    	itemId:'selectWorkflowItemId',
    	allowBlank : true,
    	fieldLabel : getDMSTranslation('WORKFLOW'),
    	store: new Ext.data.ArrayStore({
    		id: 0,
    		fields: [
    			'id',
    			'name'
			],
			data: [['1','Review and Approve (one or more reviewers) Assign a review task to multiple reviewers']]  // data is local
    	}),
    	valueField: 'id',
    	displayField: 'name',
    	triggerAction: 'all',
    	editable: false,
    	width: 600
    },{
    	xtype: 'panel',
    	hidden: true,
    	itemId: 'worflowInnerPanelItemId',
    	cls: 'workflowInnerPanelCls',
		defaults: {
			labelAlign: 'top',
    		width: 600
		},
    	items:[{
    		xtype: 'fieldset',
    		title: getDMSTranslation('GENERAL'),
    		defaults: {
    			labelAlign: 'top',
    		},
        	layout: 'column',
    		items:[{
    			xtype: 'textarea',
    			itemId: 'messageTextareaItemId',
    			allowBlank: true,
    			fieldLabel: getDMSTranslation('MESSAGE'),
        		columnWidth: 1,
        		maxLength: 250
    		},{
    			xtype: 'datefield',
    			itemId: 'dueDateItemId',
    			allowBlank: true,
    			fieldLabel: getDMSTranslation('DUE'),
        		columnWidth: 0.45,
        		format: "Y-m-d"
    		},{
    			xtype: 'displayfield',
    			hideLabel: true,
    			value: '',
    			columnWidth: 0.10
    		},{
    			xtype: 'combobox',
    			itemId: 'priorityComboItemId',
    			allowBlank: true,
    			fieldLabel: getDMSTranslation('PRIORITY'),
        		columnWidth: 0.45,
        		store: new Ext.data.ArrayStore({
            		id: 0,
            		fields: [
            			'id',
            			'name'
        			],
        			data: [['1','High'],['2','Medium'],['3','Low']]  // data is local
            	}),
            	valueField: 'id',
            	displayField: 'name',
            	triggerAction: 'all',
            	editable: false,
            	value: '2'
    		}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('ASSIGNEES'),
    		defaults: {
    			labelAlign: 'top'
    		},
        	layout: 'column',
    		items:[{
    			xtype: 'multiselectcombofield',
    			name: 'reviewers',
    			itemId: 'reviewersItemId',
    			allowBlank : false,
    			fieldLabel : getDMSTranslation('REVIEWERS'),
    			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyCombo'),
        		columnWidth: 0.45,
        		displayField : 'value',
    			valueField : 'id'
    		},{
    			xtype: 'displayfield',
    			hideLabel: true,
    			value: '',
    			columnWidth: 0.10
    		},{
    			xtype: 'textfield',
    			itemId: 'requiredApprovalPercentageItemId',
    			allowBlank : false,
    			fieldLabel : getDMSTranslation('REQUIRED_APPROVAL_PERCENTAGE'),
        		columnWidth: 0.45,
        		value: 50
    		}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('ITEMS'),
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top'
    		},
        	layout: 'column',
    		items:[{
        		xtype: 'dataview',
        		itemId: 'workflowDocumentItemId',
        		autoScroll: true,
    			columnWidth: 1,
        		store: Ext.create('Ext.data.ArrayStore',{
            		id: 0,
            		fields: ['type','img','fileName','action','time','displayTime','userName','version','size','displayVersion','folderPath','nodeRef', 'isLocked', 'lockedByUsername', 'lockedByDisplayName', 'role', 'activeWorkflows'],
        			data: []
            	}),
            	itemSelector: 'div.thumb-wrap-document-workflow',
        		tpl: new Ext.XTemplate(
    		    	   '<tpl for=".">',
    			            '<div class="thumb-wrap-document-workflow" >',
    			            	'<img src="{img}" />',
    			            	'<div class="listItem">',
    				            	'<span style="color: #333;cursor: pointer;font-size: 14px;display: inline-block;float: left;width: 80%;" class="fileNameSpan">{fileName}</span>',
    				            	'<span style="float:left;" title="{displayTime}">{action} {time} ago by {userName}</span>',
    			            	'</div>',
    			            '</div>',
    			        '</tpl>'
    		    ),
    		    emptyText: '<div style="float: left; width: 100%;text-align: center;padding: 5px;">'+getDMSTranslation('NO_ITEMS_TO_SHOW')+'</div>'
        	}]
    	},{
    		xtype: 'fieldset',
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top'
    		},
        	layout: 'hbox',
    		items:[{
    			xtype: 'button',
    			text: getDMSTranslation('START_WORKFLOW'),
    			itemId: 'startWorkflowBtnItemId',
    			ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
    		},{
    			xtype: 'button',
    			text: getDMSTranslation('CANCEL'),
    			itemId: 'cancelWorkflowBtnItemId',
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	}]
    }]
});