Ext.define('Academia.view.Viewport2', {
    extend: 'Ext.container.Viewport',
    alias: 'widget.vp2',
    style: {
        background: '#fff'
    },
    rtl: true,
    layout: 'border',
    defaults: {
        autoScroll: true
    },
    items: [{
    	region: 'north',
    	xtype: 'toolbar',
    	ui: 'acad-header',
    	height: 64,
    	items: [{
    		xtype: 'logosection',
    		loginPage: false,
    		flex: 0.5,
    		ui: 'acad-logo'
    	}, /*{
		 	xtype: 'portaldetails'
	},*/ {
    	    xtype: "combo",
    	    itemId: "searchComboBox",
    	    cls: "searchComboBoxCls has-clear-trigger searchComboBoxPosCls",
    	    triggerCls: "ph-x",
    	    store: "MainSearchStore",
    	    displayField: "searchText",
    	    valueField: "menuId",
    	    hideLabel: true,
    	    maxWidth: 540,
    	    flex: 1,
    	    height: 35,
    	    //hideTrigger: true,
    	    enableKeyEvents: true,
    	    allowCollapse: false,
    	    minChars: 0,
    	    queryMode: "local",
    	    emptyCls: "search-empty-text-field MenuSearchCLS",
    	    emptyText: getCommonTranslation("MENU_SEARCH"),
    	    matchFieldWidth: true,
    	    currentQuery: '', // Custom property to store the query
    	    listConfig: {
    	        loadingText: getCommonTranslation("SEARCHING"),
    	        emptyText: getCommonTranslation("NO_MATCH"),
    	        cls: "searchMenuListCls",
    	        getInnerTpl: function() {
    	            return [
    	            	 '<a class="searchItemCls">',
    	            	 '<span class="displayPathCls">{displayPath}</span>',
    	                    '<span class="titleCls">{highlightedTitle}</span>',
    	                '</a>'
    	            ].join('');
    	        }/*,
    	        listeners: {
    	        	refresh: function() {
    	        		var me = this;
    	        		Ext.defer(function() {
    	        			me.setY(55);
    	        		}, 1);
    	        	}
    	        }*/
    	    },
    	    listeners: {
    	        select: function(d,c,e,f) {
    	        	if(!isNullOrEmpty(c[0].data.dataObj)) {
    	        		d.allowCollapse = true;
    	        		d.dataObj=c[0].data.dataObj;
    	        		d.displayCode=c[0].data.displayCode;
    	        		d.isNewMenu=true;
    	        		d.isMenu=true;

    	        		try {

    	        			Academia.getApplication().getController('menu.CoreERPNavigationController').onNavSelectionChange(d, c[0], e, f);
    	        		} catch (b) {
    	        			$("#" + d.getValue())[0].click();
    	        		}
    	        	}
    	        	else {
    	        		$("#" + d.getValue())[0].click();
    	        	}
    	            d.setValue("");
    	            d.clearValue();
	                d.triggerEl.setDisplayed(false);
    	            setTimeout(function() {
    	                d.allowCollapse = false;
    	            }, 300);
    	        },
    	        beforequery: function(b) {
    	        	var combo = this;
    	        	var query = b.query;

    	        	// Escape special regex characters
    	        	var escapedQuery = Ext.String.escapeRegex(query);

    	        	// Create regex to match individual characters (case-insensitive)
    	        	var chars = query.split('').map(Ext.String.escapeRegex).join('|');
    	        	var regex = new RegExp('(' + chars + ')', 'gi');

    	        	// Force all records to show
    	        	b.forceAll = true;

    	        	// Highlight matched characters in the title field
    	        	combo.getStore().each(function(record) {
    	        		var title = record.get('title') || '';

    	        		// Encode HTML special characters first
    	        		var encodedTitle = title; //Ext.String.htmlEncode(title);

    	        		// Highlight the matched characters
    	        		var highlighted = encodedTitle.replace(regex, '<span class="highlightedText">$1</span>');

    	        		// Save highlighted version to another field
    	        		record.set('highlightedTitle', highlighted);
    	        	});

    	        	// Case-insensitive global regex for filtering
    	        	var regexFlags = "gi";
    	        	if (b.query === b.query.toUpperCase() && b.query.length > 1) {
    	        		regexFlags = "gi";  // Optional logic
    	        	}

    	        	// Create filtering regex with special character handling
    	        	b.query = new RegExp(escapedQuery, regexFlags);
    	        	b.forceAll = true;

    	        	// Sort store alphabetically
    	        	this.getStore().sort([{
    	        		property: "title",
    	        		direction: "ASC"
    	        	}]);
    	        },
    	        keyup: function (combo) {
    	        	// Show clear icon only if there's text
    	        	var trigger = combo.triggerEl;
    	        	if (combo.getRawValue()) {
    	        		trigger && trigger.setDisplayed(true);
    	        	} else {
    	        		trigger && trigger.setDisplayed(false);
    	        	}
    	        },
    	        render: function (combo) {
    	            // Initially hide the trigger
    	            combo.triggerEl && combo.triggerEl.setDisplayed(false);

    	            // Attach click event to trigger to clear the value
    	            combo.triggerEl.on('click', function () {
    	                combo.setValue('');
    	                combo.clearValue();
    	                combo.triggerEl.setDisplayed(false);
    	                combo.collapse();
    	                Ext.defer(function() {
    	                	combo.collapse();
    	                }, 1);
    	            });
    	            
    	            var trigger = combo.getEl().down('.x-form-trigger');
    	            if (trigger) {
    	                trigger.addCls('ph');
    	                // Reapply class on mouseover
    	                trigger.on('mouseover', function () {
    	                	if (!trigger.hasCls('ph')) {
    	                		trigger.addCls('ph');
    	                	}
    	                });
    	            }
    	        }/*,
    	        afterrender: function(cmp) {
    	        	Ext.defer(function() {
    	        	var winWidth = window.innerWidth;
    	        	var cmpWidth = cmp.getWidth();
        	        	cmp.setX((winWidth - cmpWidth) / 2, true);
    	        	}, 1000);
    	        }*/
    	        /*beforequery: function(b) {
    	            console.log('Beforequery query:', b.query, 'combo.currentQuery:', this.currentQuery); // Debug log
    	            var c = "ig";
    	            var combo = this;
    	            var input = b.query || '';
    	            combo.currentQuery = input; // Store in custom property
    	            if (input && input === input.toUpperCase() && input.length > 1) {
    	                c = "g";
    	            }
    	            b.query = new RegExp(input, c);
    	            b.forceAll = true;
    	            this.getStore().sort([{
    	                property: "title",
    	                direction: "ASC"
    	            }]);
    	        }*/
    	    }
    	}, {
    		xtype: 'notificationsection',
    		itemId:'notificationSectionPanel',
    		flex: 0.4,
    		maxWidth: 175
    	}, {
            xtype: 'button',
            itemId: 'languageName',
            cls: 'lang-name-btn',
            margin: '-1 4 0 -4',
            menu: {
            	cls: 'org-name-menu lang-menu',
            	listeners: {
            		click: function(a, b, c) {
            			if(!b.hasCls('selected-lang')) {
            				showConfirmMessage(getCommonTranslation('CHANGE_LANGUAGE'), getCommonTranslation('LANGUAGE_CONFIRMATION') + ' ' + b.text,
            						function(btn, text) {
            					if (btn == 'yes'){
            						var value  = b.code;
            						if(value!=localStorage.getItem('userLanguage')){
            							localStorage.setItem('userLanguage', (value));
            							var languageStore = Ext.getStore('common.ChangeLanguageStore');
            							localStorage.setItem('userLanguageShortName', (languageStore.findRecord('code', value).get('shortName')));
            							localStorage.setItem('userLanguageItemValue', (languageStore.findRecord('code', value).get('itemValue')));
            							window.location.reload();
            						}
            					}
            				});
            			}
            		},
            		show: function(menu) {
            			var lang = menu.up('button').lang;
            			menu.down('[text=' + lang + ']').addCls('selected-lang');
            		},
            		afterrender: function(menu) {
            			Ext.defer(function() {
            				menu.setHeight(menu.getHeight() + 2);
            			}, 10);
            		}
            	}
            }
        }, {
    		xtype: 'userinfo',
    		pack: 'right'
    	}]
    }, {
        region: 'south',
        height: 26,
        xtype: 'footersection',
        ui: 'acad-footer', // added by guru
        hidden: true
    }, {
        region: 'west',
        width: 240,
        titleCollapse: true,
        collapsible: true,
        xtype: 'verticalNavigationMenu'
    }, {
        region: 'center', // center region is required, no width/height specified
        xtype: 'contentpanel',
        align: 'stretch',
        autoScroll: true
    }]
});