/**
 * This panel is used in the Admission Settings Form of the admission Cycle.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.ApplicationSettingForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.applicationsettingform',
    title: getAdmissionTranslation('APPLICATION_FORM_SETTINGS'),
    collapsible: true,
    autoScroll: true,
    frame:true,
	layout: 'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent applicationsettingformCls', 
    defaults: {
        labelAlign: 'top'
    },
    items: [{
        xtype: 'hidden',
        name: 'id'
    },
    {
        xtype: 'hidden',
        name: 'multipleId',
        itemId :'multipleId'  
    },
    {
    xtype: 'hidden',
    name : 'documentIdUploadPath',
    itemId :'documentIdUploadPath'  
},
{
        xtype: 'hidden',
        itemId: 'versionField',
        name: 'version'
    },{
    	xtype : 'fieldcontainer',
    	width: '100%',
    	defaults : {
    		labelAlign : 'top',
    		 width: '100%'
    	}
    	},{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 230
        },
        items: [{
  	  xtype: 'datefield',
      name: 'formSaleStartDate',
      fieldLabel: getAdmissionTranslation('FORM_SALE_START_DATE'),
      vtype: 'daterange',
      itemId: 'formSaleStartDate',
      endDateField:'formSaleEndDate',
      allowBlank: false,
      editable: false,
      listeners: {
    	  render: function(field) {
    		  return dateFormatRender(field);
    	  }
      }
}, {
    xtype: 'datefield',
    name: 'formSaleEndDate',
    fieldLabel: getAdmissionTranslation('FORM_SALE_END_DATE'),
    vtype: 'daterange',
    itemId: 'formSaleEndDate',
    startDateField:'formSaleStartDate',
    allowBlank: false,
    editable: false,
    listeners: {
    	render: function(field) {
    		return dateFormatRender(field);
    	}
    }
}]
},{
    xtype: 'fieldcontainer',
    layout: {
        type: 'hbox'
    },
    defaults: {
        width: 230
    },
  
    items: [{
    	  xtype: 'datefield',
        name: 'formSubmissionStartDate',
        fieldLabel: getAdmissionTranslation('FORM_SUBMISSION_START_DATE'),
        vtype: 'daterange',
        itemId: 'formSubmissionStartDate',
        labelAlign: 'top',
        endDateField:'formSubmissionEndDate',
        allowBlank: false,
        editable: false,
        listeners: {
      	  render: function(field) {
      		  return dateFormatRender(field);
      	  }
        }
  }, {
      xtype: 'datefield',
      name: 'formSubmissionEndDate',
      fieldLabel: getAdmissionTranslation('FORM_SUBMISSION_END_DATE'),
      vtype: 'daterange',
      itemId: 'formSubmissionEndDate',
      labelAlign: 'top',
      startDateField:'formSubmissionStartDate',
      allowBlank: false,
      editable: false,
      listeners: {
      	render: function(field) {
      		return dateFormatRender(field);
      	}
      }
  }]
  },
  {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 230
		},
		items: [{
	        xtype: 'filefield',
	        name: 'documentId',
	        itemId: 'documentId',
	        fieldLabel: getCommonTranslation('UPLOAD_DOC'),
	        buttonText: getCommonTranslation('BROWSE'),
	        ui: 'CustomBtnCancel',
	        width: 300,
	        labelAlign: 'top',
	        listeners: {
	            specialkey: function(me, e) {
	                if (e.getKey() == e.TAB) {
	                    e.stopEvent();
	                }
	            }
	        }
	    } ]
  },
  {
      xtype: 'textarea',
	    width: 466,
      name: 'remark',
      fieldLabel: getCommonTranslation('REMARKS')
      
  },{
	  xtype:'fieldcontainer',
	  cls: 'form-fixed-footer',
	  width:'auto',
	  layout: {
		  type: 'hbox'
	  },
	  items:[{
		  xtype: 'button',
		  text: getCommonTranslation('SAVE'),
		  itemId: 'saveApplicationSetting',
		  ui: 'CustomBtnSubmit',
		  scale: CONSTANTS.BUTTONSIZE,
		  formBind: true
	  }]
  } ]   
    });