/**
 * This window will be shown on the add/Edit/View of the Program Group grid's Configure grid.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.ProgramGroupConfigWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.programgroupconfigwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getAdmissionTranslation('PROGRAM_GROUP_CONFIG'),
    items: [{
        xtype: 'form',
        itemId: 'documentsForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype : 'hidden',
        	name: 'version'
        },{
        	xtype : 'hidden',
        	name: 'programGroup',
        	itemId: 'programGroupHiddenField'
        },{
            xtype: 'fieldcontainer',
            fieldLabel: getAdmissionTranslation('APPLICATION_FORM_SALE'),
            layout: {
            	type:'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'datefield',
            	name: 'appFormStartDate',
            	itemId: 'appFormStartDate',
        	    vtype: 'daterange',
                endDateField: 'appFormEndDate',
            	fieldLabel: getAdmissionTranslation('START_DATE'),
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                format: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            }, {
            	xtype: 'datefield',
            	name: 'appFormEndDate',
            	itemId: 'appFormEndDate',
            	vtype: 'daterange',
                startDateField: 'appFormStartDate',
            	fieldLabel: getAdmissionTranslation('END_DATE'),
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                format: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            }]
        }, {
        	xtype: 'checkboxfield',
        	boxLabel: getAdmissionTranslation('ENABLE_ONLINE_SALE'),
            name : 'onlineSalePermitted',
            itemId: 'onlineSalePermitted',
            inputValue: true,
            uncheckedValue : false
        },{
            xtype: 'fieldcontainer',
            fieldLabel: getAdmissionTranslation('APPLICATION_FORM_SUBMISSION'),
            layout: {
            	type:'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'datefield',
            	name: 'appFormSubmitStartDate',
            	itemId: 'appFormSubmitStartDate',
            	vtype: 'daterange',
                endDateField: 'appFormSubmitEndDate',
            	fieldLabel: getAdmissionTranslation('START_DATE'), 
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                format: CONSTANTS.DATE_FORMAT,
                listeners:{
                	render: function(field) {
						return dateFormatRender(field);
					},
                	change:function(cmp,value){
                		if(!value){
                			var nextField=cmp.nextSibling();
                			nextField.setMinValue(false);
                		}
                	}
                }
            }, {
            	xtype: 'datefield',
            	name: 'appFormSubmitEndDate',
            	itemId: 'appFormSubmitEndDate',
            	vtype: 'daterange',
                startDateField: 'appFormSubmitStartDate',
            	fieldLabel: getAdmissionTranslation('END_DATE'), 
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                format: CONSTANTS.DATE_FORMAT,
                listeners:{
                	render: function(field) {
                		return dateFormatRender(field);
                	},
                	change:function(cmp,value){
                		if(!value){
                			var nextField=cmp.previousSibling();
                			nextField.setMaxValue(false);
                		}
                	}
                }
            }]
        }, {
        	xtype: 'checkboxfield',
        	boxLabel: getAdmissionTranslation('ENABLE_ONLINE_SUBMISSION'),
            name      : 'onlineSubmissionAllowed',
            itemId: 'onlineSubmissionAllowed',
            inputValue: true,
            uncheckedValue : false
        }, {
        	xtype : 'fieldcontainer', 
        	layout:'hbox', 
        	items:[{
    			xtype : 'customcombobox',
    			name : 'template',
    			width: 256,
    			labelAlign: 'top',
    			fieldLabel : getAdmissionTranslation('TEMPLATE'),
    			//TODO: implementation pending , implement after functionality confirmation
                allowBlank: true,
                //store: 'Academia.store.admission.selectionProcess.Applicabilities',
                displayField: 'value',
                valueField: 'name'
            }, {
    			xtype : 'numberfield',
    			itemId: 'maxProgramsAllowed',
    			name : 'maxProgramsAllowed',
    			width: 256,
    			labelAlign: 'top',
    			fieldLabel : getAdmissionTranslation('MAX_PROGRAM_ALLOWED'),
                allowBlank: true,
                displayField: 'value',
                valueField: 'name',
            }] 
        }, {
        	xtype: 'filefield',
        	name: 'photo',
			//TODO: implementation pending due to dependency
            buttonText: getCommonTranslation('BROWSE'),
            fieldLabel: getCommonTranslation('UPLOAD_DOC'), 
            allowBlank: true,
            buttonConfig: {
                ui: 'CustomBtnCancel'
            }
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveProgramGroupConfig',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});