/**
 * This window is used to show the Selection Process grid in a window
 * of the selection process type.
 * @author Akshay.Kalbhor
 * @author Rupesh.Agrawal
 */
Ext.define('Academia.view.admission.admissionCycle.SelectionProcessGridWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.selectionprocessgridwindow',
    autoScroll: true,
    modal: true,
    resizable: false,
    margin: 0,
    width: '60%',
    height: '70%',
    title: getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
    items: [{
        xtype: 'treepanel',
        cls: 'no-tree-icon',
        rootVisible: false,
        singleExpand: true,
        store: 'Academia.store.admission.admissionCycle.SelectionProcessesTree',
        title: getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
        border: true,
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },

        columns: [{
            xtype: 'treecolumn',
            text: getAdmissionTranslation('SELECTION_STAGE'),
            dataIndex: 'selectionProcessStage',
            flex: 1
        }, {
            text: getAdmissionTranslation('START_DATE'),
            dataIndex: 'startDate',
            sortable: true,
            flex: 1,
    		renderer : function(date) {
    			return dateRender(date);
    		}
        }, {
            text: getAdmissionTranslation('END_DATE'),
            dataIndex: 'endDate',
            sortable: true,
            flex: 1,
    		renderer : function(date) {
    			return dateRender(date);
    		}
        }, {
            text: getAdmissionTranslation('EVALUATION_PARAMETER'),
            dataIndex: 'evaluationParameter',
            sortable: true,
            flex: 1
        }, {
            text: getAdmissionTranslation('WEIGHTAGE'),
            dataIndex: 'weightage',
            sortable: true,
            flex: 1
        }]
    }]
});