Ext.define('Academia.view.admission.applicationFollowUpReport.ApplicationFollowUpDashboardFilter', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.applicationfollowupdashboardfilter',
	//autoScroll: true,
	frame: false,
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	cls: 'customSearchPanel',
	plugins:"formlabelrequired",
	defaults: {
		labelAlign: 'top',
	},
	items:[{
		xtype:'fieldcontainer',
		itemId: 'applicationfollowupDetailsConatiner',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'multiselectcombofield',
			width: 690,
			height:58,
			name: 'multiselectAcademyLocation',
			itemId: 'academyLocationId',
			allowBlank : false,
			fieldLabel : getAdmissionTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]  
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		style: {
			marginLeft:'-0px !important'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name:'applicantId',
			itemId:'applicantId',
			store:Ext.create('Academia.store.admission.applications.applicantProfileBase.ApplicantSmartSearchStore'),
			fieldLabel:getAdmissionTranslation('APPLICANT_ID_OR_NAME'),
			width: 536,
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: 'all',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code}/{printName}'  +
	                    '</div>';
	                }
	            }
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width: 256,
			editable: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.BatchIntakeYearStore');
					combo.bindStore(store)
				}}
		},{
			xtype: 'customcombobox',
			name: 'applicationOwner',
			store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
			fieldLabel: getCommonTranslation('APPLICATION_OWNER'),
			valueField: 'id',
			displayField: 'value',
			itemId:'applicationOwnerId',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//forceSelection:true,
			allowBlank:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'programId',
			itemId:'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			displayField:'valueCode',
			width: 536,
			valueField:'id',
			store: 'program.ProgramByGroupIdStore',
			minChars:3,
			queryParam:'qry',
            forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getAdmissionTranslation('BATCH'),
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:true,
			editable: false
		}]  
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'followUpUser',
			store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
			fieldLabel: getCommonTranslation('FOLLOW_UP_USER'),
			valueField: 'id',
			displayField: 'value',
			itemId:'followUpUserId',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		},
		{
			xtype: 'datefield',
			name: 'fromdate',
			itemId:'fromdate',
			allowBlank : true,
			
			vtype: 'daterange',
			endDateField: 'todate',
			fieldLabel: getAdmissionTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name: 'todate',
			itemId:'todate',
			allowBlank : true,
			vtype: 'daterange',
			startDateField: 'fromdate',
			fieldLabel: getAdmissionTranslation('TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'datefield',
			name: 'scheduleFromDate',
			itemId:'scheduleFromDate',
			allowBlank : true,
			vtype: 'daterange',
			endDateField: 'scheduleToDate',
			fieldLabel: getCommonTranslation('SCHEDULE_FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name: 'scheduleToDate',
			itemId:'scheduleToDate',
			allowBlank : true,
			vtype: 'daterange',
			startDateField: 'scheduleFromDate',
			fieldLabel: getCommonTranslation('SCHEDULE_TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
