/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show applicant details in form  
 */
Ext.define('Academia.view.admission.applicationFormSale.ApplicantFormDetails', {
    //extend: 'Ext.form.FormPanel',
    //extend:'Academia.view.common.CustomForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.APPLICATION_SALE_FORM_CUSTOM_FIELD,
    alias: 'widget.applicantformdetails',
    title: getAdmissionTranslation('APPLICANT_DETAILS'), //Applicant Details
    plugins: "formlabelrequired",
    border: true,
    cls: 'horizontalScrollingFixed',
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    bodyPadding: '10 10 10 25',
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'panel',
        itemId: 'searchComponent',
        autoScroll: true,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top'
        },
        style: {
            marginBottom: '-12px'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'applicationType',
            itemId: 'cmbApplicationType',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            width: 256,
            queryMode: 'local',
            value: 'FRESH_APPLICANT',
            allowBlank: false,
            listeners  :{
            	render : function(combo){
            		  var store=Ext.create('Academia.store.admission.applicationFormSale.ApplicantTypeStore');
            		  combo.bindStore(store)
            	}
            }
        }, {
            xtype: 'fieldcontainer',
            itemId: 'enquiryPanel',
            layout: {
                type: 'hbox'
            },
            hidden : true,
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                name: 'enqId',
                itemId: 'enqId',
                fieldLabel : getAdmissionTranslation('ENQUIRY_ID') //Enquiry ID					
            }, {
                xtype: 'textfield',
                name: 'enqName',
                itemId: 'enqName',
                fieldLabel : getAdmissionTranslation('STUDENT_NAME') //Enquirer Name 					
            },{
                xtype: 'numberfield',
                name: 'enqContactNo',
                itemId: 'enqContactNo',
                hideTrigger: true,
                fieldLabel : getAdmissionTranslation('CONTACT_NO')//Contact No.
            }, {
                xtype: 'textfield',
                name: 'enqEmailId',
                itemId: 'enqEmailId',
                fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID
            }]}, {
                xtype: 'fieldcontainer',
                itemId: 'applicantPanel',
                layout: {
                    type: 'hbox'
                },
                hidden : true,
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
               items:[{
                xtype: 'textfield',
                name: 'appId',
                itemId: 'appId',
                fieldLabel : getAdmissionTranslation('APPLICATION_ID')//Application Id 					
            }, {
                xtype: 'textfield',
                name: 'appName',
                width: 256,
                itemId: 'appName',
                fieldLabel : getAdmissionTranslation('APPLICATION_NAME')//Application Name
            }]}, {
                xtype: 'textfield',
                name: 'studentId',
                itemId: 'studentId',
                hidden: true,
                width: 256,
                fieldLabel : getAdmissionTranslation('STUDENT_ID')
            },{
            xtype: 'button',
            text: getAdmissionTranslation('SEARCH'), //Search                
            itemId: 'searchButton',
            hidden: true,
            style : {
            	marginLeft : '0px',
            	marginRight : '2px'
            },
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
    	xtype: 'fieldset',    	
        items: [{    	
		        xtype: 'fieldcontainer',        
		        labelAlign: 'top',
		        width: 'auto',
		        items: [{
		        	fieldLabel: getAdmissionTranslation('APP_ENQ_STD_ID'), // Application/Enquiry/Student ID
		            xtype: 'displayfield',
		            name: 'code',            
		            labelWidth: 'auto',
		            hidden:true,                  
		            itemId: 'dispalyCode',
		            fieldStyle:{
		            	marginTop: '4px !important'
		            }
		            	
		        }, {
		            xtype: 'hidden',
		            name: 'applicantId',
		            itemId: 'applicantId'
		        },{
		            xtype: 'hidden',
		            name: 'saleRefPrimaryId',
		            itemId: 'saleRefPrimaryId'
		        }, {
		            xtype: 'hidden',
		            name: 'saleRefId',
		            itemId: 'saleRefId'
		        }, {
		            xtype: 'hidden',
		            name: 'saleRefType',
		            itemId: 'saleRefType'
		        }]
        }]    
    },{
    	xtype: 'fieldset',
    	itemId : 'personalDetailFieldset',
    	title: getAdmissionTranslation('PERSONAL_DETAILS'), // Personal Details
        items: [{
            xtype: 'fieldcontainer',        
            labelAlign: 'top',
            width: 'auto',
            layout: {
                type: 'vbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'checkboxfield',
                width: 'auto',
                itemId: 'isEmployeeOrganisation',
                labelAlign: 'right',
                boxLabel: getPersonModuleTranslation('EMPLOYEE_OF_ORGANIZATION'),
                name: 'isEmployeeOfOrganization',
                inputValue: true,
                hidden: true,
                uncheckedValue: false
            }, {
                xtype: 'textfield',
                itemId: 'employeeId',
                fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID'),
                name: 'employeeId',
                disabled: true,
                hidden: true,
                allowBlank: false
            }]
        },{
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('SALUTATION'),
                name: 'salutation',
                store: 'common.SalutationStore',
                valueField: 'id',
                displayField: 'salutationName',
                queryMode: 'local',
                allowBlank: false,
                editable: false
            }, {
                xtype: 'textfield',
                name: 'firstName',
                fieldLabel: getAdmissionTranslation('FIRST_NAME'), //First Name
                allowBlank: false,
                vtype: 'spaceAndSpecialCharactersAsInput'
            },{
                xtype: 'textfield',
                name: 'middleName',
                fieldLabel: getAdmissionTranslation('MIDDLE_NAME'), //Middle Name
                vtype: 'spaceAndSpecialCharactersAsInput'
            }]
        }, {
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [  /*{
                xtype: 'textfield',
                name: 'shortName',
                fieldLabel: getAdmissionTranslation('SHORT_NAME'), //Short Name       
                hidden: true
            }*/]
        }, { 
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                name: 'lastName',
                fieldLabel: getAdmissionTranslation('LAST_NAME'), //Last Name       
                //allowBlank: false,
                vtype: 'spaceAndSpecialCharactersAsInput'
            },{
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('SHORT_NAME'),
                name: 'shortName',
//                maxLength : 20,
    			enforceMaxLength :true,
                allowBlank: false,
                vtype: 'spaceAndSpecialCharactersAsInput'
            }, {
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('PRINT_NAME'),
                name: 'printName',
                allowBlank: false,
                vtype: 'spaceAndSpecialCharactersAsInput'
            }]
        }, { 
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            xtype: 'datefield',
            name: 'birthDate',
            itemId: 'birthDate',
            fieldLabel: getAdmissionTranslation('BIRTHDATE'), //Birth Date
            //editable: true,
            maxValue: new Date(),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
//            format: CONSTANTS.DATE_FORMAT,
            allowBlank: false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	},
            	change : function(date){var calcAge = date.up('form').getForm().findField('ageAsOnBirthDate');
                // console.log('calcAge....',calcAge);
                var today = new Date();
                var birthDate = new Date(date.lastValue);
                var age = today.getFullYear() - birthDate.getFullYear();
                var m = today.getMonth() - birthDate.getMonth();
                /*if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                    age--;
                }*/
                /*if(today.getDate() < birthDate.getDate()){
               	 age--
                }*/
                if(birthDate==today){
               	 age==0; m==0;
                }else{
                    if((age==0 && m<0) ){
                   	 age--;
                   	 m =  -m;
                    }else if((age==1 && m<0)){
                   	 age--;
                   	 m = 12 + m;
                    }else{
                    if(m<0){
                   	 age--;
                   	 m = 12 + m;
                     }
                   }
                } 
                
                //var month = 12 + (m-1);
                calcAge.setValue(age + ' Year'+' '+ m +' Months');
                }
            }
        }, {
			xtype: 'textfield',
			fieldLabel: getCommonTranslation('PRESENT_AGE'),
			itemId: 'ageAsOnBirthDate',
			format: CONSTANTS.DATE_FORMAT,
			name: 'ageAsOnBirthDate',
			editable: false,
			readOnly:true,
			disabled:true,
		},{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('GENDER'), //Gender
            name: 'gender',
            valueField: 'id',
            displayField: 'value',
            store: 'enquiry.studentDetail.GenderStore',
            queryMode: 'local',
            editable: false,
            allowBlank: false
        }]
       }]
    },{
    	xtype: 'fieldset',
    	itemId : 'contactFieldSet',
    	 defaults: {
 	    	labelAlign: 'top'
 	    },
    	title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
        items: [{
        	html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>'+'<span class="required" style="color:red"> *</span>',
        	margin: 0
        },{
    		xtype: 'fieldcontainer',
    		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
	   		//allowBlank:false,
    		layout : {
    			type : 'hbox'
    		},
    		items : [ {
    			xtype : 'customcombobox',
    			hiddenName : 'phoneNumber1',
    			valueField : 'isdCode',
    			displayField : 'isdCode',
    			store:'common.CountryStore',
    			queryMode: 'local',
    			triggerAction : 'all',
    			name : 'phoneCountryCode',
    			itemId : 'phoneCountryCode',
    			editable : false,			
    			width: 80
    		}, {
    			xtype : 'numberfield',
    			name : 'phoneAreaCode',
    			width: 108,
    			maxLength: 5,
    			enforceMaxLength : true,
    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
    	        hideTrigger: true,
    	        keyNavEnabled: false,
    	        mouseWheelEnabled: false,
    	        allowExponential:false
    		}, {
    			xtype : 'numberfield',
    			itemId : 'phoneNoField',
    			name : 'phoneNo',
    			maxLength: 10,
    			enforceMaxLength : true,
    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
    	        hideTrigger: true,
    	        width: 256,
    	        keyNavEnabled: false,
    	        mouseWheelEnabled: false,
    	        allowExponential:false
    		} ]
    	}, {
    	    	xtype: 'fieldcontainer',
    	    	fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
	    		layout : {
	    			type : 'hbox'
	    		},
    		items : [ {
    			xtype : 'customcombobox',
    			name : 'mobileCountryCode',
    			itemId : 'cellCountryCode',
    			valueField : 'isdCode',
    			displayField : 'isdCode',
    			store:'common.CountryStore',
    			queryMode: 'local',
    			triggerAction : 'all',
    			editable : false,
    			width: 80
    		}, {
    			xtype : 'numberfield',
    			name : 'mobileNumber',
				minLength: 6,
				maxLength: 11,
    			enforceMaxLength : true,
    			// To Remove spinner buttons, and arrow key and mouse wheel listeners
    	        hideTrigger: true,
    	        keyNavEnabled: false,
    	        mouseWheelEnabled: false,
    	        allowExponential:false,
    	        width: 256
    		}]
    	},{
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [ {
                xtype: 'textfield',
                fieldLabel: getAdmissionTranslation('EMAIL_ID'), //Email ID
                name: 'emailId',
                vtype: 'email',
                allowBlank: false
    		},{
                xtype: 'datefield',
                name: 'submissionDate',
                itemId: 'submissionDate',
                fieldLabel: getAdmissionTranslation('SUBMISSION_DATE'), //Submission Date
                editable: false,
                readOnly : true,
//                value : new Date(),
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                format: CONSTANTS.DATE_FORMAT,
                listeners: {
          		  render: function(obj) {
          			  obj = dateFormatRender(obj);						
          			  obj.setValue(new Date());
          		  }
          	  }
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style:{
        	marginLeft:'8px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'), //Save
            formBind: true,
            itemId: 'saveApplicantFormDetails',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('CANCEL_OR_RESET'), //Cancel/Reset
            itemId: 'cancelApplicationFormDetails',
            hidden:true,
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getExaminationTranslation('RESET'),
            itemId: 'gradeMasterResetButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            handler: function() {
                this.up('form').getForm().reset();
            }
        }]
    }]
});
