/**
 * @author Rajkumar.patidar
 * 
 * This component is used for to show program details in grid 
 */
Ext.define('Academia.view.admission.applicationFormSale.ChangeProgramWindowGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.changeprogramwindowgrid',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    border: true,    
    initComponent: function() {
    	var grid=this;                
    	var store=Ext.create('Academia.store.admission.applicationFormSale.AddProgramGridStore');
    	var toolBarItems=new Array();
    	store.getProxy().api.read = SERVERURL.FIND_CONFIGURED_PROGRAMS_BY_PROGRAMGROUPID;//.APPLICATION_FORM_SALE_PROGRAM_WINDOW_GRID_DATA;
    	toolBarItems=grid.getToolBarItems(true);
    	
        this.doLayout();
        Ext.apply(this, {
            store: store,
            tbar:toolBarItems
        });
        this.callParent(arguments);
        
        var custompagingtoolbar=grid.down('custompagingtoolbar');
        if(custompagingtoolbar){
        	custompagingtoolbar.bindStore(store);        	
        }
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')           
        }]
    }],
    columns: [{
            header: getAdmissionTranslation('ACADEMY'), //Academy 
            dataIndex: 'academy.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('LOCATION'), //Location
            dataIndex: 'location.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('PROGRAM'), //Program
            dataIndex: 'program.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('BATCH'), //Batch
            dataIndex: 'batch.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
            dataIndex: 'seatType.value',
            flex: .2,
            sortable: true
        }],
    	
    getToolBarItems:function(directAdmisison){
    	 	var store;
    	 	if(directAdmisison)
    	 		 store=Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore');
    	 	else
    	 		 store=Ext.create('Academia.store.admission.applicationFormSale.ActiveProgramGroupComboStore');
            
    	var items=[{
                xtype: 'customcombobox',
                name: 'pgmGroup',
                itemId: 'cmbPgmGroup',
                fieldLabel: getAdmissionTranslation('SELECT_PROGRAM_GROUP'), //Select Program Gorup
                 //Select Program Gorup  
                labelWidth:150,
                width: 536,
                store:store,
                valueField: 'id',
                displayField: 'value',
                editable: false,
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false            
        }];
    	return items;
    }  
});
