/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show collection details in form  
 */
Ext.define('Academia.view.admission.applicationFormSale.CollectionFormDetails', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.collectionformdetails',
    title: getAdmissionTranslation('COLLECTION_DETAILS'), //Collection Details
    plugins: "formlabelrequired",
    border: true,
    bodyPadding: '10 10 10 25',
    items: [{
        xtype: 'hidden',
        name: 'id',
        itemId: 'hiddenId'
    }, {
        xtype: 'hidden',
        name: 'version',
        itemId: 'versionId'
    }, {
        xtype: 'fieldset',
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                name: 'appFormSaleDate',
                itemId: 'appFormSaleDate',
                fieldLabel: getAdmissionTranslation('APP_FRM_SALE_DATE'), // Application Form Sale Date
                editable: false,
                // Select application form sale date
                format: CONSTANTS.DATE_FORMAT,
//                value: new Date(),
//                submitFormat: CONSTANTS.DATE_FORMAT,
                allowBlank: false,
                listeners: {
                	render: function(obj) {
                		obj = dateFormatRender(obj);						
                		obj.setValue(new Date());
                	}
                }
            }, {
                xtype: 'customcombobox',
                name: 'collectedBy',
                itemId: 'cmbCollectedBy',
                fieldLabel: getAdmissionTranslation('COLLECTED_BY'), // Collected By
                store: 'admission.applicationFormSale.CollectedByComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                // Select collected by                         
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false
            }]
        }]
    }, {
        xtype: 'fieldset',
        itemId: 'autofillFormId',
        title: getAdmissionTranslation('FORM_HANDED_OVER_TO'), // Form Handed Over To- :
        items: [{
            xtype: 'fieldcontainer',
            fieldLabel: getAdmissionTranslation('AUTOFILL_FORM'), // Autofill the form below using
            layout: {
                type: 'hbox'
            },
            labelAlign: 'top',
            defaults: {
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                name: 'ref',
                itemId: 'cmbRef',
                store: 'admission.applicationFormSale.SaleRefTypeComboStore',
                valueField: 'name',
                displayField: 'value',
                editable: false,
                // Select Ref             
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true
            }, {
                xtype: 'customcombobox',
                name: 'saleRef',
                itemId: 'cmbSaleRef',
                store: 'admission.applicationFormSale.SaleRefComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                // Select Sale Ref             
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                name: 'firstName',
                itemId: 'firstName',
                fieldLabel: getAdmissionTranslation('FIRST_NAME'), //First Name
                //Enter first name
                allowBlank: false
            }, {
                xtype: 'textfield',
                name: 'middleName',
                fieldLabel: getAdmissionTranslation('MIDDLE_NAME') //Middle Name
            },{
            	  xtype: 'textfield',
                  name: 'lastName',
                  fieldLabel: getAdmissionTranslation('LAST_NAME'), //Last Name       
                  //Enter last name
                  //allowBlank: false
              }] 
            },{
                xtype: 'fieldcontainer',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                	 xtype: 'textfield',
                     fieldLabel: getPersonModuleTranslation('SHORT_NAME'),
                     name: 'shortName',
                     maxLength: 20,
                     enforceMaxLength: true,
                     allowBlank: false
                 }, {
                     xtype: 'textfield',
                     fieldLabel: getPersonModuleTranslation('PRINT_NAME'),
                     name: 'printName',
                     allowBlank: false
                 }, {
                     xtype: 'textfield',
                     fieldLabel: getAdmissionTranslation('EMAIL_ID'), //Email ID
                     name: 'emailId',
                     //Enter Email Id
                     vtype: 'email',
                     allowBlank: false
                }] 
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                labelAlign: 'top',
                fieldLabel: getAdmissionTranslation('LAND_LINE_NO'), //Land Line No        	        	
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    enforceMaxLength: true
                },
                items: [{
                    xtype: 'customcombobox',
                    hiddenName: 'phoneNumber1',
                    valueField: 'isdCode',
                    displayField: 'isdCode',
                    store: 'common.CountryStore',
                    queryMode: 'local',
                    triggerAction: 'all',
                    name: 'phoneCountryCode',
                    itemId: 'phoneCountryCode',
                    editable: false,
                    width: 80
                }, {
                    xtype: 'numberfield',
                    name: 'phoneAreaCode',
                    maxLength: 5,
                    width: 108,
                    spinDownEnabled: false,
                    spinUpEnabled: false,
                    allowExponential: false,
                    hideTrigger: true
                }, {
                    xtype: 'numberfield',
                    itemId: 'landLineNo',
                    name: 'phoneNo',
                    //Enter land line no
                    maxLength: 10,
                    width: 256,
                    spinDownEnabled: false,
                    spinUpEnabled: false,
                    allowExponential: false,
                    hideTrigger: true
            }]
            }, {
                xtype: 'fieldcontainer',
                fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
                layout: {
                    type: 'hbox'
                },
                    labelAlign: 'top',
                items: [{
                    xtype: 'customcombobox',
                    name: 'mobileCountryCode',
                    itemId: 'cellCountryCode',
                    valueField: 'isdCode',
                    displayField: 'isdCode',
                    store: 'common.CountryStore',
                    queryMode: 'local',
                    triggerAction: 'all',
                    editable: false,
                    width: 80
                }, {
                    xtype: 'numberfield',
                    name: 'mobileNumber',
    				minLength: 6,
    				maxLength: 11,
                    enforceMaxLength: true,
                    // To Remove spinner buttons, and arrow key and mouse wheel listeners
                    hideTrigger: true,
                    keyNavEnabled: false,
                    mouseWheelEnabled: false,
                    allowExponential: false,
                    width: 256
                }]
        }, {
            xtype: 'button',
            itemId: 'manageAddress',
            hidden: true,
            name: 'manageAddress',
            ui: 'CustomBtnCancel',
            text: getCommonTranslation('MANAGE_ADDRESS'), //Address
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'textareafield',
            name: 'address',
            itemId: 'address',
            fieldLabel: getAdmissionTranslation('ADDRESS'), //Address
            //Enter address details
            labelAlign: 'top',
            width: 475,
            height: 100,
            maxLength: 250
        }]
    }]
});