/**
 *  @author Amit G
 */

Ext.define('Academia.view.admission.applicationOwnerSetup.VWAdmAppOwnerFacultyCampusGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.vwadmappownerfacultycampusgrid',
	title : getCommonTranslation('ACADEMY_LOCATION'),
	store: 'feeandpayment.AcademyLocationFeeMappingList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: true,
	//height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'admNextBtnFacultyCampusItemId',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'admSubmitBtnFacultyCampusItemId',
		scale: CONSTANTS.BUTTONSIZE
	},,{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'admResetBtnCommonItemId',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'admFacultyCampusSearchCombo',
		itemId:'admFacultyCampusSearchComboItemId',
		store: 'common.AcademyLocationByName',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'name',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		},
		style:{
			'margin-left':'10px !important'
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
//		translationKey:'ACADEMY_LOCATION',
		dataIndex : 'value',
		flex : 1	 
	}]
});