/**
 * @author Amit G
 * 
 * This component is used for to App Owner User form  
 */
Ext.define('Academia.view.admission.applicationOwnerSetup.VWAdmAppOwnerUserIdTabForm', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.vwadmappowneruseridtabform',
	plugins: "formlabelrequired",
	cls:'vwadmappowneruseridtabformCls',
	style:{
		'margin-left':'20px !important',
		'border-top':'1px solid !important'
	},
	items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			style:{
				'margin-top':'25px !important',
			    'margin-left': '30px !important'
			},
			title:getCommonTranslation('USER'),
			layout: {
				type: 'hbox'
			},
			defaults:{
				labelAlign:'top'
			},
			items: [{
    			xtype: 'customcombobox',
    			name: 'admAppOwnerUser',
    			itemId:'admAppOwnerUserItemId',
    			fieldLabel: getCommonTranslation('USER_CODE_NAME'),
    			store: 'admission.applicationOwnerSetup.StoAdmAppOwnerUserFindAllStore',
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'name',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			width:456,
    			forceSelection:true,
    			allowBlank:false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}/{nameToBePrinted}' +
    					'</div>';
    				}
    			}
    		
            }]
	}, {
		xtype: 'fieldcontainer',
		width:'auto',
		style:{
			'margin-top':'10px !important',
		    'margin-left': '27px !important'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('NEXT'),
			itemId: 'admBtnNextForm',
			ui: 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'admBtnUserComboResetForm',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
