/**
 * @author trupti.paoneker
 *  
 * This component is used for layout of Mid-Term tab
 * 
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.MidTermAdmission', {
    extend: 'Ext.form.Panel',
    alias: 'widget.midtermadmission',
    title:getAdmissionTranslation('MID_TERM_ADMISSION_DETAILS'), //Mid-Term Admission Details
    itemId : 'applicantMidTermAdmissionDetails',
    closable : true,
    autoScroll: false,
    cls:'panelNoSpace',       
    items: [{
	    xtype: 'midtermmaincoursesgrid',
	    itemId:'applicantMidTermMainCoursesGrd'
	}, {
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '10px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'), //Save
            formBind: true,
            itemId: 'saveApplicationDetails',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            hasDisableForProfileViewMode:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'), //Cancel
            itemId: 'cancelApplicationDetails',
            ui: 'CustomBtnCancel',
            hidden:true,
            scale: CONSTANTS.BUTTONSIZE,
            hasDisableForProfileViewMode:true
        }]
    },{
	    xtype: 'midtermothercoursesgrid',
	    itemId:'applicantMidTermOtherCoursesGrd'
	 }]
});