/**
 * @author pritam.patil
 * This is used to set AddAdmissionProgramWindow
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.ViewAdmissionDetailsForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.viewadmissiondetailsform',
    modal: true,
    autoScroll: true,
    frame: true,
    height: (Ext.isIE8) ? 600 : '65%',
    width: (Ext.isIE8) ? 600 : '65%',
    title: getAdmissionTranslation('ADMISSION_DETAILS'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'dynamicfieldformwin',
        itemId: 'admissionDetailsForm',
//        readOnly : true,
        items: [{
            xtype:'fieldcontainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                    xtype: 'textfield',
                    name: 'acadLoc',
                    fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION')
        }]},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                name: 'programVal',
                itemId: 'program',
                fieldLabel: getServiceRequestTranslation('PROGRAM')
            }, {
                xtype: 'textfield',
                name: 'batchVal',
                itemId: 'batch',
                fieldLabel: getServiceRequestTranslation('BATCH')
            },{
                xtype: 'textfield',
                name: 'seatTypeVal',
                itemId: 'seatType',
                fieldLabel: getServiceRequestTranslation('SEAT_TYPE')
            }]},{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{ 
                    xtype: 'textfield',
                    name: 'admissionType',
                    itemId: 'typeOfAdmission',
                    fieldLabel: getAdmissionTranslation('TYPE_OF_ADMISSION')
                },{
                    xtype: 'textfield',
                    name: 'status',
                    fieldLabel: getAdmissionTranslation('ADMISSION_STATUS')
                },{
                    xtype: 'textfield',
                    name: 'advisiorName',
                    itemId: 'advisiorId',
                    fieldLabel: getAdmissionTranslation('ADVISOR')
                }]}, {
                	xtype: 'fieldcontainer',                                 
                    itemId: 'trialAdmissionDateContainer',
                    hidden: true,
                    layout: {
                        type: 'hbox'
                    },
                    defaults: {
                        labelAlign: 'top',
                        width: 256                        
                    },           
                    items: [{
                        xtype: 'textfield',
                        fieldLabel: getAdmissionTranslation('TRIAL_START_DATE'), //Trial Start Date
                        name: 'trialStartDate',
                        itemId: 'trialStartDate'                     
                    }, {
                        xtype: 'textfield',
                        fieldLabel: getAdmissionTranslation('TRIAL_END_DATE'),  //Trial End Date
                        name: 'trialEndDate',                        
                        itemId: 'trialEndDate'
                    }]
                }, {
                    xtype: 'radiogroup',                    
                    fieldLabel: getAdmissionTranslation('NO_CONCLUSION_TRIAL_END_DATE'),  //If no conclusion by trial end date, assume following decision
                    labelAlign : 'top',
                    itemId: 'whetherDenied',
                    hidden: true,
                    layout: {
                        type: 'hbox'
                    },
                    items: [{
                        boxLabel: getAdmissionTranslation('CONFIRMED'),  //Confirmed
                        name: 'whetherConfirmed',
                        inputValue: 'CONFIRMED'
                    }, {
                        boxLabel: getAdmissionTranslation('WITHDRAWN'),  //Withdrawn
                        name: 'whetherWithdrawl',
                        inputValue: 'WITHDRAWN'
                    }]
                },{
                    xtype: 'fieldcontainer',                
                    width: '100%',
                    hidden: true,
                    itemId: 'provisionalAdmissionPanel',
                    layout: {
                        type: 'vbox'
                    },
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'textfield',
                        fieldLabel: getAdmissionTranslation('PROVISIONAL_LAST_DATE'), //Last Date for Provisional Confirmation 
                        name: 'provisionalLastDate',
                        itemId: 'provisionalLastDate'
                    }, {
                        xtype: 'radiogroup',
                        fieldLabel: getAdmissionTranslation('NO_CONCLUSION_LAST_DATE'), //If no conclusion by last date, assume following decision
                        name: 'whetherConfirmed',                    
                        layout: {
                            type: 'hbox'
                        },
                        items: [{
                            boxLabel: getAdmissionTranslation('CONFIRMED'),  //Confirmed
                            name: 'whetherConfirmed',
                            inputValue: 'CONFIRMED'
                        }, {
                            boxLabel:getAdmissionTranslation('DENIED'),  //Denied
                            name: 'whetherDenied',
                            inputValue: 'DENIED'
                        }]
                     },{
                            fieldLabel: getAdmissionTranslation('REASON_PROVISIONAL_ADMISSION'), //Reason for Provisional  Admission
                            xtype: 'textarea',                        
                            width: 256,
                            itemId: 'provisionalAdmissionClosureReason',
                            name: 'provisionalAdmissionClosureReason'
                        }]            
        	}, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'followUpDetailsCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(){
                	this.up('window').close()
                }

            }]
        }]
    }]
});
