/**
 * @author vidhi.shah
 * 
 */
var AdmissionGridStore = Ext.create('Academia.store.admission.applications.applicantProfileBase.AdmissionGridStore');
Ext.define('Academia.view.admission.applications.applicantProfileBase.AdmissionGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.admissiongrid',
    store: AdmissionGridStore,
    title: getAdmissionTranslation('SELECT_PROGRAM_APPROVE'),	    
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },    
    isGridConfigurable: true,
    enableColumnHide: false,
    tbar:[],
    columns: [{
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionId',
        hidden:true,
        flex: .2
    }, {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academy.value',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'location.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'program.value',
        flex: .2,
        sortable: true        
    }, {
        header: getCommonTranslation('MODE_OF_DELIVERY'), 
        dataIndex: 'modeOfDelivery.value',
        sortable: true,
        flex: .2,
    	hidden: true
    }, {
        header: getCommonTranslation('REGISTRATION_TYPE'),
        dataIndex: 'batchPartTime',
        sortable: true,
        flex: .2,
    	hidden: true,
    	renderer : function(value) {
        	if(!isNullOrEmpty(value)) {
        		if(value==false) {
        			return 'Full Time';
        		}
        		else {
        			return 'Part Time';
        		}
        	}
        }
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batch.value',
        flex: .2,
        sortable: true
    },{
    	header: getCommonTranslation('PERIOD'),
        dataIndex: 'programBatchPeriodConfiguration.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('SEAT_TYPE'),
        dataIndex: 'seatType.value',
        flex: .2,
        sortable: true
    }, {
		header: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
		dataIndex: 'schoolAttendanceStartDate',
		flex: .2,
		sortable: true,
		renderer: function(val) {
				if(!isNullOrEmpty(val)){
                   return dateRender(val);
                }
		}
	}, {
        header: getCommonTranslation('ADMISSION_DATE_AD'),
        dataIndex: 'admissionDate',
        sortable: true,
        hidden:true,
        flex: .2 ,
        renderer : function(value){
        		return  dateRender(value);
        	
        }
    }, {
    	header: getCommonTranslation('SECTION'),
        dataIndex: 'section.value',
        flex: .2,
        sortable: true
    }, {
    	header: getCommonTranslation('ADVISOR'),
        dataIndex: 'advisiorName',
        flex: .2,
        sortable: true
    },{
    	header: getCommonTranslation('TYPE_OF_ADMISSION'),
        dataIndex: 'admissionType',
        flex: .2,
        sortable: true
    }],      
    dockedItems: [{
        xtype: 'toolbar',
        hidden:true,
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,                	
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            store: AdmissionGridStore
        }]
    }]
});

