/*
 * @author prathamesh.sheth
 * 
 * Application profile Screen.
 *    
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.ApplicantProfile', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.applicantprofile',
    cls: 'panelNoSpace',
    width: 'auto',
    personId: '',
    personObj: {},
    style:{
		'top':'-12.5px !important'
	},
    defaults: {
        autoScroll: true
    },
    layout: {
        type: 'border'
    },
    initComponent: function() {
        this.items = [{
            xtype: 'panel',
            region: 'center',
            cls: 'panelNoSpace',  
            autoScroll: true,
            layout: {
                type: 'vbox'
            },
            items: [{
            xtype: 'panel',            
            cls: 'panelNoSpace',
            itemId:'applicantSummaryPanel',
            hidden:true,
            autoScroll: false,            
            layout: {
                type: 'hbox'
            },
            style:{
		    	'border':'1px solid #e0e0e0 !important',
		    	'marginTop':'30px !Important',
		    	'marginLeft':'10px !Important',
		    	'marginRight':'10px !Important',
		    	'border-radius': '5px;'
		    },
		    width: '100%',
            items:[{
                xtype: 'panel',
                itemId: 'imageParentPanel',
                width: '100%',
                style: {
                    marginTop: '0px !important'
                },
                items: [{
	            	xtype:'image',
	                itemId: 'profile_image',
	                customId: 'profileImageRef',
	                border: 1,
	                style: {
	                	borderColor: '#e0e0e0',
                        borderStyle: 'solid',
                        borderRadius:'50%',
                        marginTop: '25px !important',
                        marginLeft: '13px !important'
	                },
	                width: 64,
					height: 64
	            },{
				    xtype: 'container', // Using container to manage custom HTML
				    itemId: 'profile_image_icon_id',   
				    style: {
				        marginTop: '25px',
				        marginLeft: '13px',
				        margin: '0px',
	                    right: 'auto',
	                    left: '90px',
	                    top: '25px',
	                    position: 'absolute',
	                    hidden:false,
				    },
				    html: '<span class="hoverElement" style="display: inline-block; width: 25px; height: 25px; border: 1px solid #e0e0e0; border-radius: 50%; overflow: hidden; padding: 5px; position: absolute; left: -32px; background-color: #fff; top: 35px;">' +
				          '<img class="hoverImage" src="resources/images/Edit_Pro.svg" style="width: 100%; height: 100%; object-fit: cover;">' +
				          '</span>'
				}, {
	                xtype: 'profiletemplate',
	                itemId: 'applicantProfileTemplate',
	                height:220,
	                style: {
	                	 marginTop: '-123px !important',
	                	 marginLeft: '85px !important',
	                }               
	            }]
            }]
          },{
        	  xtype: 'panel',            
              cls: 'panelNoSpace',
              autoScroll: false,            
              layout: {
                  type: 'vbox'
              },
  		    	width: '100%',
  		    	items:[{
  		    		xtype: 'fieldset',            
  		    		title:getCommonTranslation('EXPAND_SELECTION_SNAPSHOT'),
  		    		collapsible:true,
  		    		itemId: 'applicantExpandContainerItemId',
  		    		border:true,
  		    		style:{'margin-left': '10px !important'},
  		    		frame:true,	
  		    		width: '97%',
  		    		height: 500,
  		    		collapsed:true,
  		    		layout: 'fit',
  		    		items:[{
  		    			xtype: 'selectionsnapshotgrid',
  		    			itemId:'selectionSnapShotGrid',
  		    			flex: 1,  
  		    			width: '100%',
  		    			style: {
  		    				marginLeft: '10px !important',
  		    				borderBottom: '1px solid #e0e0e0'
  		    			}
  		    		}]
  		    	},{
            	  xtype: 'personinfopanel',
                  itemId: 'personInfoPanel',
                  minWidth: 800,
                  defaults: {
                      border: false
                  },
                  style : {
                  	marginLeft : '15px'
                  }
              }]
          }]
        }, {
            xtype: 'persondetailslinkpanel',
            personType:'APPLICANT',
            itemId : 'applicantPersonDetailsLinkPanel',
            width: '20%',
            region: 'east',
            cls: 'panelNoSpace',
            header:{
				layout:
			    {
			        type: 'hbox',
			        pack: 'end'
			    },
				items:[
					{
			        	xtype: 'combo',
			        	itemId: 'applicantPersonalDetailLinkSearchComboBox',
			        	cls: 'searchComboBoxCls1 est_combo_cls',
			            store: Ext.create('Academia.view.personinfo.common.PersonDetailsLinkSearchStore'),
			            displayField: 'searchText',
			            valueField: 'menuId',
			            hideLabel: true,
			            width:'85%',
			            hideTrigger:true,
			        	enableKeyEvents: true,
			        	allowCollapse: false,
			        	minChars: 0,
			        	queryMode: 'local',
			        	emptyCls: 'search-empty-text-field',
			        	style: 'left:0 !important; top: 0 !important;',
			        	emptyText: getCommonTranslation('SEARCH'),
			        	anyMatch:    true,
			            listConfig: {
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_MATCH'),
			                cls: 'searchMenuListCls searchMenuListApplicantWidthCls',
			                getInnerTpl: function() {
			                    return '<a class="searchItemCls">' +
			                        '<span class="displayPathCls" style="margin-left: 10px;">{displayPath}</span><span class="titleCls" style="left: 10px;">{title}</span>' +
			                    '</a>';
			                }
			            },
			            listeners: {
			            	select: function(combo, record){
			            		var parentPanelSelector = record[0].get('parentPanelSelector'),
			            			currentElementSelector = record[0].get('currentElementSelector'),
			            			currentItemIndex = record[0].get('currentItemIndex');
			            		
			            		Ext.getCmp(parentPanelSelector).up().expand();
			            		if(Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector).length == 0) {
			            			setTimeout(function(){
			            				Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            			},500);
			            		}
			            		else {
				            		Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            		}
			            		combo.clearValue();
			            	},
			            	beforequery: function(record){  //Added for sorting & any match
			            		this.getStore().sort([{
			                    	property : 'title',
			                    	direction: 'ASC'
			                    }]);
			                }
			            }
			        }
				]
			},
			hideHeaders : false,
			animate : true,
			animCollapse: true,
			titleCollapse : true
        }, {
            xtype: 'actionbuttonpanel',
            itemId : 'actionButtonPanel',
            width: '10%',
            region: 'south',
            cls: 'panelNoSpace',
            margin : '0 0 0 13'
        }];

        this.callParent(arguments);
    }    
 });