/**
 * This form is used to display check list items .
 * @author Pritam.Patil
 */
Ext.define('Academia.view.admission.applications.applicantservice.ApplicantCheckListItemWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.applicantchecklistitemwindow',
    modal: true,
    autoScroll: true,
    maxHeight:'400',
    frame: true,
    items: [{
        xtype : 'form',
        itemId : 'programBatchFormId',
        items :[{
    	xtype: 'fieldcontainer',
    	width: '100%',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('ACADEMY'),            
            readOnly : true,
            submitValue: false,
            name: 'academy',
            itemId : 'academyId'
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('LOCATION'),            
            readOnly : true,
            submitValue: false,
            name: 'location',
            itemId : 'locationId'
        }]
    },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	  width: '100%',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('PROGRAM'),            
                readOnly : true,
                submitValue: false,
                name: 'programName',
                itemId : 'programId'
            },{
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('BATCH'),            
                readOnly : true,
                submitValue: false,
                name: 'batchName',
                itemId : 'batchId'
            }]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	  width: '100%',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('SEAT_TYPE'),            
                readOnly : true,
                submitValue: false,
                name: 'seatTypeName',
                itemId : 'seatTypId'
            }]
        },{
    	  xtype: 'dataview',
          itemId: 'checklistTemplateId',
          store: 'admission.applications.applicantservice.ApplicantChekLists',
          itemSelector: 'div.thumb-wrap',
          emptyText : '<div style="margin-top: 10px;" class="thumb-wrap">'+ getCommonTranslation('NORESULTSNMESSAGE')+'</div>',
          tpl:  new Ext.XTemplate( '<div style=" margin-top: 20px;" ><B>'+ getCommonTranslation('CHECK_LIST')+'</B></div>',
        		 '<tpl for=".">',
  		        '<div style="margin-bottom: 10px;" class="thumb-wrap">',
	        	'<br/><span>{checklistValue}</span>',
	        	'<div style="border-bottom:1px solid #ccc;height:1px;margin-bottom:10px; width: 50%;"></div>',
	        '</div>',
	    '</tpl>')
    }]}]
});