/**
 * @author Sooraj Prasad
 * This is used for load Applicant academic grid
 */

Ext.define('Academia.view.admission.applications.applicationBase.ApplicationDocumentsAndNotesGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicationdocumentsandnotesgrid',
	title: getPersonModuleTranslation('DOCUMENTS_AND_NOTES'),
	border: true,
	viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    isGridConfigurable: true,
    enableColumnHide: false,
       tbar: [{
       xtype: 'button',
       itemId: 'btnAdd',
       tooltip: getCommonTranslation('ADD'),
       glyph: ICONGLYPH.ADDGLYPH,
       hasDisableForProfileViewMode:true
   }, {
       xtype: 'button',
       itemId: 'btnEdit',
       tooltip: getCommonTranslation('EDIT'),
       glyph: ICONGLYPH.EDITGLYPH,
       hasDisableForProfileViewMode:true
   }, {
       xtype: 'button',
       itemId: 'btnView',
       tooltip: getCommonTranslation('VIEW'),
       iconCls: 'view-icon'
   }, {
       xtype: 'button',
       itemId: 'btnDelete',
       cls: 'CustomToolbarBtnReject',
       tooltip: getCommonTranslation('DELETE'),
       glyph: ICONGLYPH.DELETEGLYPH,
       hasDisableForProfileViewMode:true
   }],
    columns: [{
        header: getAdmissionTranslation('APPLICATION_ID'),
        dataIndex: 'application',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	return value.code;  
        }
    },{
        header: getAdmissionTranslation('APPLICANT_NAME'),
        dataIndex: 'applicantName',
        flex:.3,
        sortable: true,
       
    }, {
		header: getPersonModuleTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
        header: getPersonModuleTranslation('BATCH'),
        dataIndex: 'batch',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	return value.value;  
        }
    },{
        header: getPersonModuleTranslation('PERIOD'),
        dataIndex: 'period',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(value)
        		return value.value
        	else 
        		return '';  
        }
    },{
        header: getCommonTranslation('DATE'),
        dataIndex: 'date',
        flex:.3,
        sortable: true,
        renderer: function(date) {
	    	return dateRender(date);
	    }
        
    },{
        header: getCommonTranslation('CATEGORY'),
        dataIndex: 'category',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('SUB_CATEGORY'),
        dataIndex: 'subCategory',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	return value.value;  
        }
    }, {
        header: getPersonModuleTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex:.3,
        sortable: true,
       /* renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(isNullOrEmpty(val)){
        		return "";
        	} else {
        		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
        		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
        		return val;
        	}
        }*/
	    renderer:function(val,rec,record,rowIndex,colIndex,store,view){
	    	if(!isNullOrEmpty(val)) {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"'; 
				rec.style = 'text-align:left;overflow:hidden; text-overflow: ellipsis;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 16px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return val;
				}else{
					return "";
				}
		}

	},{
		header: getCommonTranslation('CREATED_DATE'),
		dataIndex: 'createdAt',
		flex:.3,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('CREATED_BY'),
		dataIndex: 'createdBy',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return val.code.toLowerCase() + '/' + val.value;
		}
	},{
		header: getCommonTranslation('UPDATED_DATE'),
		dataIndex: 'updatedAt',
		flex:.3,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('UPDATED_BY'),
		dataIndex: 'updatedBy',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return val.code.toLowerCase() + '/' + val.value;
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:.3,
		sortable: true
	},{
		header: getPersonModuleTranslation('PUBLISH_ON_STUDENT_OR_PARENT_PORTAL'), 
		dataIndex: 'isPublished',
		flex:.3,
		sortable: true
    },{
		header: getCommonTranslation('UPLOADED_DOCUMENTS'),
		dataIndex: 'uploadedDocuments',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(rec.record.get('documentName'))) {
				var value1=!isNullOrEmpty(rec.record.get('documentName'))?rec.record.get('documentName'):rec.record.data.name;
				var newPath=rec.record.data.path;    
				var val=!isNullOrEmpty(value1)?value1:newPath;
				return "<a href='javascript:void(0)'>"+val;
			}
			else {
				return "";
			}
		}
	},{
		header: getCommonTranslation('UPLOADED_URLS'),
		dataIndex: 'applicantAcademicTopicUrl',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(rec.record.get('urlName'))) {
				if(rec.record.get('applicantAcademicTopicUrl').length == 1) {
					value = rec.record.get('applicantAcademicTopicUrl')[0].name;
					var value1=!isNullOrEmpty(value)?value:rec.record.get('applicantAcademicTopicUrl')[0].name;
					var newPath=rec.record.get('applicantAcademicTopicUrl')[0].path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href="+newPath+" target='_blank'>"+val;
				}
				else {
					var value1=!isNullOrEmpty(rec.record.get('urlName'))?rec.record.get('urlName'):rec.record.data.name;
					var newPath=rec.record.data.path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href='javascript:void(0)'>"+val;
				}
			}
			else {
				return "";
			}
		}
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
    		return Ext.create('Academia.store.admission.applications.applicationReviewer.ApplicationDocumentAndNotesStore');
    }
});