/**
 * @author Amit G
 * This is used to show CONDITIONS_FOR_ADMISSIONS Application and Admission
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationProgramWiseConditionsForAdmission', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.applicationprogramwiseconditionsforadmission',
    autoScroll: true,
    items: [{
    	xtype: 'panel',
    	width:'100%',
    	items: [{
    		xtype:'panel',
    		items: [{
    		xtype : 'applicationprogramwiseconditionsadmissionadmgrid',
    		itemId: 'applicationProgramWiseConditionsAdmissionAdmGridItemId',
    		isFixHeightGrid: true,
    		minHeight: 0,
    		tbar:[]
    		}]
    	},{
    		xtype: 'panel',
        	layout: 'hbox',
        	style: {
        		'margin-left': '-32px !important;',
        		'margin-right': '24px !important;'
        	},
        	defaults: {
        		autoScroll: true
        	},
        	items: [{
        		xtype: 'applicantpwconditionsadminadmdocumentgrid',
        		itemId: 'applicantPWConditionsAdminAdmDocumentGridItemId',
        		minHeight: 0,
        		cls:'no-empty-placeholder-grid zero-right-margin-grid',
        		width:490,
        		isFixHeightGrid: true,
        		isFixWidthColums: true
        	},{
        		xtype: 'applicantlistofapplicableconditionsadmgrid',
        		itemId: 'applicantListofApplicableConditionsAdmgridItemId',
        		flex: 1,
        		isFixHeightGrid: true,
        		isFixWidthColums: true,
        		minHeight: 0,
        		cls:'no-empty-placeholder-grid'
        	}]	
    	}]

    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	style:{
    		'margin':'20px !important'
    	},
    	itemId:'formFieldContainerItemId',
    	defaults: {
    		labelAlign: 'top',
    		
    	},
    	items: [{
    		xtype: 'textarea',
    		name: 'txtAdmAdditionalCondition',
    		style:{'margin-left':'10px'},
    		width: 536,
    		itemId: 'txtAdmAdditionalConditionItemId',
    		fieldLabel: getAdmissionTranslation('ADDITIONAL_CONDITIONS'),
    		readOnly:true,
    		maxLength:1000	
    	},{
    		xtype: 'datefield',
    		fieldLabel: getAdmissionTranslation('DATE_FOR_SATISFACTION_OF_CONDITION'),
    		name: 'admDateOfSatisfactionCondition',
    		itemId: 'admDateOfSatisfactionConditionItemId',
    		width: 256,
    		readOnly:true,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]
	},{
		xtype: 'fieldcontainer',
    	style:{
    		'margin':'20px 25px !important'
    	},
    	items: [{
		xtype: 'button',
		text: getTransportTranslation('SAVE'),
		formBind: true,
		itemId: 'admPWCSubmitBtn',
		ui: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
		style: {
			'margin-left': '5px !important;'
		}
		}]
	}]	
});