/**
 *  vidhi.shah
 */

Ext.define('Academia.view.admission.applications.applicationBase.BulkApplicationRejectionWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.bulkapplicationrejection',
    modal: true,
    autoScroll:true,
    title: getCommonTranslation('REJECT_APPLICATION'),
    height:350,
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: 'anchor',
        standardSubmit: false,
        plugins:"formlabelrequired",
        defaults: {
        	  labelAlign: 'top',
        	  width: 256,
        },
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
            	xtype:'displayfield',
            	itemId:'totalRecordsId',
            	name:'totalRecords'
        	}, {
                xtype: 'customcombobox',
                name: 'reasonId',
                itemId: 'cmbRejectReason',
                fieldLabel: getAdmissionTranslation('REASON_FOR_REJECTION'), 
                store: 'admission.applications.applicantProfileBase.ReasonsForRejectionComboStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                width: 256,
                labelAlign: 'top',
                allowBlank: false
            }, {
                xtype: 'textareafield',
                name: 'remark',
                fieldLabel: getAdmissionTranslation('REJECTION_REMARKS'), 
                labelAlign: 'top',
                width: 256,
                maxLength: 250
			},{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }]
});