/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.admission.applications.applicationBase.OfferLetterDetailsWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.offerletterdetailswindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '40%',
	//height: 'auto',
	width: '80%',
	frame: true,
	title:getCommonTranslation('OFFER_LETTER_DETAILS'),
	items : [{
			xtype: 'grid',
			store : Ext.create('Academia.store.admission.applications.applicationBase.OfferLetterDetailsStore'),
			autoScroll: true,
			itemId : 'offerLetterDetailsGrid',
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			features: [{
				ftype: 'summary',
				showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			dockedItems : [/*{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'admission.applications.applicationBase.OfferLetterDetailsStore',
					emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}*/],
			columns: [{
				header : getCommonTranslation('OFFER_TYPE'),
				dataIndex : 'offerLetterType',
				flex : 0.2,
				renderer: function(val, rec,e){
			        if(!isNullOrEmpty(val)){
			        return  getAdmissionTranslation(val)+" Offer";
			        } else {
			        return "NA";
			        }
			       }
			},{
				header : getCommonTranslation('OFFER_LETTER_SENT_DATE'),
				dataIndex : 'offerLetterSentDate',
				flex : 0.2,
				renderer: function(date) {
					return dateRender(date);
				}
			},{
				header : getCommonTranslation('SENT_BY'),
				dataIndex : 'offerLetterSentByName',
				flex : 0.2
			},{
				header : getCommonTranslation('OFFER_LETTER_ACCEPTANCE_DATE'),
				dataIndex : 'offerLetterAcceptanceDate',
				flex : 0.2,
				renderer: function(date) {
					return dateRender(date);
				}
			},{
				header : getAdmissionTranslation('OFFER_LETTER_ACCEPTED_FOR'),
				dataIndex : 'acceptedFor',
				flex : 0.2
			},{
				header : getAdmissionTranslation('OFFER_LETTER_ACCEPTED_BY'),
				dataIndex : 'offerLetterAcceptedByUserName',
				flex : 0.2
			},{
				header : getCommonTranslation('OFFER_LETTER'),
				dataIndex : 'fileName',
				flex:0.2,
				renderer:function(value,rec){
					//var id=rec.record.data.id;
					if(value!="" && value!=undefined && value != null){
						return '<a href="#">'+value+'</a>';
					}else{
						return "NA";
					}
				}
			}] 	

		}]
});
