Ext.define('Academia.view.admission.applications.applicationBase.ProgramSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.programsearch',
    autoScroll: false,
    border:true,
    cls:'customSearchPanel',
    //frame: true,
    layout: 'vbox',
    items: [{
        xtype: 'form',
        itemId: 'applicationsProgramSearchForm',
        defaults: {           
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'fieldset',
        	title: getAdmissionTranslation('FILTER_BY_PROGRAM'),   //Filter By Program
            items: [{
                xtype: 'fieldcontainer',            
                width: 'auto',
                layout: 'hbox',
                defaults: {
                    width: 200,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('ACADEMY'),   //Academy
                    name: 'ACADEMY',
                    itemId: 'academy',
                    editable: false,
                       //Academy
                    store: 'Academia.store.common.AcademyStore',                 
                    valueField: 'id',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                },{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('LOCATION'), //Location
                    name: 'LOCATION',
                    itemId: 'location',
                    editable: false,
                     //Location
                    store: 'Academia.store.facilitiesresources.resourcemaster.LocationListStore',
                    disabled:true,
                    valueField: 'id',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                },{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('PROGRAM'), //Program
                    name: 'PROGRAM',
                    itemId: 'program',
                    editable: false,
                     //Program
                    store: 'Academia.store.common.ProgramStore',
                    disabled:true,
                    valueField: 'id',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                },{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
                    name: 'BATCH',
                    itemId: 'batch',
                    editable: false,
                       //Batch
                    store: 'Academia.store.common.BatchesByProgramId',
                    disabled:true,
                    valueField: 'id',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                }]
            },{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'hbox',
                defaults: {
                    width: 200,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
                    name: 'SEAT_TYPE',
                    itemId: 'seatType',
                    editable: false,
                     //Seat Type 
                    store: 'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore',
                    disabled:true,
                    valueField: 'id',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                }]

            }]
        },{
        	xtype: 'fieldset',
        	title: getAdmissionTranslation('ADDITIONAL_PARAMETERS'),   //Additional Parameters
            items: [{
                xtype: 'fieldcontainer',            
                layout: 'hbox',
                defaults: {
                    width: 200,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'textfield',
                    name: 'ENQUIRY_NO',
                    itemId: 'enquiryNo',
                       //Enquiry No.
                    fieldLabel: getAdmissionTranslation('ENQUIRY_NO')   //Enquiry No.                                
                }, {
                    xtype: 'textfield',
                    name: 'APPLICATION_ID',
                    itemId: 'applicationID',
                       //Application No.
                    fieldLabel: getAdmissionTranslation('APPLICATION_NO')   //Application No.
                }, {
                    xtype: 'textfield',
                    name: 'APPLICANT_NAME',
                    itemId: 'applicantName',
                       //Applicant Name
                    fieldLabel: getAdmissionTranslation('APPLICANT_NAME')   //Applicant Name
                },{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('APPLICATION_STATUS'), //Application Status
                    name: 'APPLICATION_STATUS',
                    itemId: 'applicationStatus',
                    editable: false,
                     //Application Status
                    store: 'admission.applications.applicationBase.ApplicationStatusComboStore',                 
                    valueField: 'name',
                    displayField: 'value',
                    value : 'SOLD',
                    queryMode : 'local'
                }]
            },{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'hbox',
                defaults: {
                    width: 200,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('PROGRAM_STATUS'), //Program Status
                    name: 'PROGRAM_STATUS',
                    itemId: 'programStatus',
                    editable: false,
                     //Program Status
                    store: 'admission.applications.applicationBase.ApplicationProgramStatusComboStore',                 
                    valueField: 'name',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                },{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('SELECTION_PROCESS_STAGE'), //Selection  Process Stage
                    name: 'SELECTION_PROCESS_STAGE',
                    itemId: 'selectionProcessStage',
                    editable: false,
                     //Selection  Process Stage
                    store: 'Academia.store.course.CourseStageStore',                 
                    valueField: 'id',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                },{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('STAGE_STATUS'), //Stage Status
                    name: 'STAGE_STATUS',
                    itemId: 'stageStatus',
                    editable: false,
                     //Stage Status
                    store: 'admission.applications.applicationBase.ApplicationStageStatusComboStore',                 
                    valueField: 'name',
                    displayField: 'value',
                    //value : 'All',
                    queryMode : 'local'
                }]
         }]
        },{
            xtype: 'fieldcontainer',
            width: 'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
		                xtype: 'button',
		                text: getAdmissionTranslation('SEARCH'), //Search
		                itemId: 'applicationsListProgramSearchBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE
            		}]
        }]
     }]  
});