/**
 * @author Prathamesh Sheth.
 *  
 * This component is used for layout of Application Details tab
 * 
 */
Ext.define('Academia.view.admission.applications.applicationDetailsAndReferences.ApplicationDetails', {
    extend: 'Ext.form.Panel',
    alias: 'widget.applicationdetails',
    plugins: "formlabelrequired",    
    title:getAdmissionTranslation('APPLICATION_DETAILS'), //Application Details
    itemId : 'applicantApplicationDetails',
    closable : true,
    autoScroll: false,
    cls:'panelNoSpace',    
    items: [{xtype:'panel',
    	items:[
    		{
    	    	xtype:'addprogramtabgrid',
    	    	title:getAdmissionTranslation('PROGRAM_APPLIED'), //Programs Applied
    	    	applicationProgramType:'APPLICANT_PROFILE_APPLICATION_PROGRAMS',
    	    	itemId:'selectedApplicantApplicationProgramGrid',
    	    	isFixHeightGrid: true,
    	    	minHeight: 0
    	    }
    ]},{
        xtype: 'fieldcontainer',
        fieldLabel: getAdmissionTranslation('ADDITIONAL_INFORMATION'), // Addtional Information
        labelAlign: 'top',
        width: 'auto',
        hidden:true,
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign:'top'
        },
        style: {
            marginLeft: '10px'
        },
        items: [{
            xtype: 'numberfield',
            name: 'familyIncome',
            fieldLabel: getAdmissionTranslation('FAMILY_INCOME'), //Family Income
             //Family Income
            maxLength: 15,
            minValue: 0,
            allowBlank: false
        },{
            xtype: 'nestedJsonCombo',
            name: 'reservationCategory',
            itemId: 'reservationCategory',
            store: 'Academia.store.enquiry.studentDetail.ReservationCategoryStore',
            valueField: 'id',
            displayField: 'value',
            editable: false,
            fieldLabel: getAdmissionTranslation('RESERVATION_CATEGORY'), // Reservation Category
             // Reservation Category             
            //queryMode: 'local',
            triggerAction: 'all',
            forceSelection: true,
            allowBlank: false
        }]    
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        hidden:true,
        style: {
            marginLeft: '10px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'), //Save
            formBind: true,
            itemId: 'saveApplicationDetails',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            hasDisableForProfileViewMode:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'), //Cancel
            itemId: 'cancelApplicationDetails',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            hasDisableForProfileViewMode:true
        }]
    }]
});