/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.admission.applications.applicationDetailsAndReferences.ApplicationReferenceForm', {
    //xtype: 'form',
    itemId: 'referenceForm',
    plugins: "formlabelrequired",
    //extend:'Academia.view.common.CustomFieldForm',
    extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity:CONSTANTS.APPLICTION_REFERENCE,
    alias: 'widget.applicationreferenceform',
    standardSubmit: false,
    defaults : {
		labelAlign:'top',
		enforceMaxLength : true,
		width: 256
	},
    items: [{
        xtype: 'hidden',
        itemId: 'referenceHiddenField',
        name: 'id'
    }, {
        xtype: 'hidden',
        itemId: 'referenceOrder',
        name: 'referenceOrder'
    },{
        xtype: 'hidden',
        itemId: 'encryptedReferenceId',
        name: 'encryptedReferenceId'
    },  {
    	xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
		    	xtype: 'customcombobox',
				name: 'salutation',
				fieldLabel:getAdmissionTranslation('SALUTATION'),
				store: 'common.SalutationStore',
				queryMode: 'remote',
				valueField: 'id',
				displayField: 'salutationName',
				//width: 100,
				allowBlank:false,
				itemId:'salutation',
				forceSelection:true,
				editable: false
		  	},{
		  		fieldLabel: getAdmissionTranslation('FULL_NAME'), //References Name
	            xtype: 'textfield',
	            itemId: 'referenceName',
	            name: 'referenceName',
	            labelAlign: 'top',
	            allowBlank: false,
	            width: 256,
	            maxLength: 100
		  	  }]
		},{
		    xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
		    	type: 'hbox'
		    },
		    items: [{
		    	xtype: 'fieldcontainer',
		    	itemId : 'mobileNoFldItemId',
		    	fieldLabel: getAdmissionTranslation('CONTACT_NO'), //Contact No.
		    	layout : {
		    		type : 'hbox'
		    	},
				defaults: {
                   enforceMaxLength: true,
                   labelAlign: "top",
                   width: 256
               },
			    items: [{
					xtype : 'customcombobox',
					name : 'mobileCountryCode',
					itemId : 'mobileCountryCode',
					valueField : 'isdCode',
					displayField : 'isdCode',
					store:Ext.create('Academia.store.common.CountryStore'),
					triggerAction : 'all',
					//editable : false,
					forceSelection:true,
					width:  80,
					minChars: 1
				},{
		            xtype: 'numberfield',
		            itemId: 'contactNo',
		            name: 'contactNo',
		            labelAlign: 'top',
		            maxLength: 15,
					minLength:0,
					// To Remove spinner buttons, and arrow key and mouse wheel listeners
			        hideTrigger: true,
			        keyNavEnabled: false,
			        mouseWheelEnabled: false,
		            allowExponential:false,
		            width: 136,
		            labelSeparator: ''
			    }]
		    },{
		    	xtype: 'textfield',
				name: 'emailId',
				itemId:'emailId',
				fieldLabel: getAdmissionTranslation('EMAIL'),
				vtype:'myemail',
				allowBlank:false,
				maxLength:100,
				//enforceMaxLength : true
		    }] 
		},{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
		    	fieldLabel: getAdmissionTranslation('AFFILIATION'), //References Name
	            xtype: 'textfield',
	            itemId: 'affiliation',
	            name: 'affiliation',
	            labelAlign: 'top',
	            width: 256
		    },{
		    	fieldLabel: getAdmissionTranslation('DESIGNATION'), //Designation
	            xtype: 'textfield',
	            itemId: 'designation',
	            name: 'designation',
	            labelAlign: 'top',
	            width: 256,
	            maxLength: 100
		    }] 
		},,{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
		    	xtype: 'customcombobox',
				name: 'waived',
				fieldLabel:getAdmissionTranslation('WAIVED'),
				store: 'common.YesNoClientSideComboStore',
				queryMode: 'remote',
				valueField: 'name',
				displayField: 'value',
				//width: 100,
				itemId:'waived',
				forceSelection:true,
				editable: false
		    },{
		    	fieldLabel: getAdmissionTranslation('REMARK'), //Reference Remark
	            xtype: 'textfield',
	            itemId: 'remark',
	            name: 'remark',
	            labelAlign: 'top',
	            width: 256
		    }] 
		},{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            itemId: 'btnSaveReferencesForm',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'btnCancelReferencesMasterForm',
            text: getCommonTranslation('CANCEL'), //Cancel
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});