/**
 * Amit G
 */

Ext.define('Academia.view.admission.applications.applicationFollowUp.ApplicationFollowUpDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicationfollowupdetailgrid',
    title: getEnquiryTranslation('LIST_OF_FOLLOWUP_DETAILS'),
    border: true,
    refreshStoreData:true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS,
	loadMask: false,
	markDirty:false
    },
    autoScroll: true,
    tbar : [{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		cls:'applicationfollowupdetailgridEditBtnCls'
	},{
		xtype : 'customcombobox',
		name : 'appointmentTypes',
		itemId : 'appointmentTypes',
		store : Ext.create('Academia.store.student.studentprofile.StudentFollowUpAppointmentStore'),
		fieldLabel : getEnquiryTranslation('SG_APPOINTMENTS'),
		valueField : 'id',
		displayField : 'value',
		//allowBlank : false,
		labelAlign: 'right',
		hidden:true,
		typeAhead : true,
		margin:'0 10 0 10',
		forceSelection : true,
		labelWidth: 105,
		cls:'appointmentTypesCls'
	}],
    columns : [{
	    header :getEnquiryTranslation('FOLLOW_UP_SCHEDULE'),
	    dataIndex : 'followUpDate',
	    flex:1,
		renderer:function(date) {
		return dateRender(date);
		}
	},{
	    header :getEnquiryTranslation('FOLLOW_UP_STATUS_UPDATE_DATE_AND_TIME'),
	    dataIndex : 'followupStatusUpdateTime',
	    flex:1,
	    hidden:true,
		renderer:function(date) {
            if(!isNullOrEmpty(date)){
             var newDateTIme=    Ext.Date.parse(date,'d-m-Y H:i:s').getTime();
             return '<div>'+dateRender(newDateTIme)+'</div>'+" "+'<div>'+timeRender(newDateTIme)+'</div>';
            }else{
                return null;            
            }
            }
	}, {
	    header :getEnquiryTranslation('FOLLOW_UP_DATE'),
	    dataIndex : 'actualFollowUpDate',
	    flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
	    header : getEnquiryTranslation('FOLLOW-UP_ACTIVITY_TYPE'),
	    dataIndex : 'followUpActivityType',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getEnquiryTranslation('REASON_FOR_FOLLOW-UP'),
	    dataIndex : 'reasonForFollowUp',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getEnquiryTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
	    dataIndex : 'followUpActivityStatus',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	}, {
	    header : getEnquiryTranslation('FOLLOW_UP_USER'),
	    dataIndex : 'users',
	    flex:1,
	    renderer:function(t,r){
	    	if(t!=null){
            return t.value;
	    	}else{
	    		return '';
	    	}
	    }
	},{
	    header : getEnquiryTranslation('REMARK'),
	    dataIndex : 'remark',
	    flex:1,
	    renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			 rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			 rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 55px;min-width: 16ch;max-width: 17ch;';
			 return val;
		 }
	}, {
	    header : getEnquiryTranslation('STATUS'),
	    dataIndex : 'status',
	    hidden:true,
	    flex:1,
	    renderer:function(val, meta, record, rowIndex){
	    	return val;
	    }
	}],
	initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.applications.applicationFollowUp.ApplicationFollowUpDetailStore');
    }


});