/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of Applicant Details in grid  
 */
Ext.define('Academia.view.admission.preAdmissionFeesAndRefund.ApplicantGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.preadmissionapplicantgrid',    
    title: getAdmissionTranslation('LIST_OF_APPLICANTS'), //List of Applicants	
    plugins: [{
        ptype: 'rowexpander',
        pluginId: 'applicantRowExpander',        
        rowBodyTpl: new Ext.XTemplate('<td colspan="5"><table style="border:1px solid black;width: 100%;">', 
        			'<tr>', 
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('ACADEMY') + '</th>',
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('LOCATION') + '</th>', 
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('PROGRAM') + '</th>', 
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('BATCH') + '</th>', 
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('SEAT_TYPE') + '</th>', 
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEES_AMOUNT') + '</th>',
        				'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEES_PLAN') + '</th>',
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('RECEIPT_NO') + '</th>',
        			'</tr>',
        			'<tpl for=".">',
        			'<tr>', 
        				'<td style="width:100px;text-align:center">{academy}</td>',
        				'<td style="width:100px;text-align:center">{location}</td>', 
        				'<td style="width:100px;text-align:center">{program}</td>', 
        				'<td style="width:100px;text-align:center">{batch}</td>',
        				'<td style="width:100px;text-align:center">{seatType}</td>',
        				'<td style="width:100px;text-align:center">{feeAmount}</td>',
        				'<td style="width:100px;text-align:center">{feePlan}</td>', 
        				'<td style="width:100px;text-align:center">{receiptNo}</td>',
        			'</tr>', 
        			'</tpl>',
        		'</table></td>')
    }],
    border: true,    
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
    	var store= Ext.create('Academia.store.admission.preAdmissionFeesAndRefund.ApplicantGridStore');
    	var this$=this;
    	var columns=new Array();
    	var tbarFields=new Array();
    	var extraToolBar=new Object();
    	var toolBar=new Array();
    	
    	if(this$.applicationFeeFlag && !isNullOrEmpty(this$.applicationFeeFlag)){
    		 columns=this$.getApplicationFeeColumnArray();    		     		 
    		 tbarFields=this$.getApplicationFeeTbarFieldsArray();
    		 tbarFields=tbarFields.concat(this$.getCommonTbarFieldsArray());
    		 toolBar=this$.getMainToolBar(tbarFields);
    	}else if(this$.submissionFeeFlag && !isNullOrEmpty(this$.submissionFeeFlag)){
	   		 columns=this$.getSubmissionFeeColumnArray();    		     		 
			 tbarFields=this$.getSubmissionFeeTbarFieldsArray();
			 toolBar=this$.getMainToolBar(tbarFields);
			 extraToolBar=this.getSubmissionFeeExtraTbar();
			 toolBar=toolBar.concat(extraToolBar);
    	}else if(this$.stageFeeFlag && !isNullOrEmpty(this$.stageFeeFlag)){
	   		 columns=this$.getStageFeeColumnArray();    		     		 
			 tbarFields=this$.getStageFeeTbarFieldsArray();
			 tbarFields=tbarFields.concat(this$.getCommonTbarFieldsArray());
			 toolBar=this$.getMainToolBar(tbarFields);
			 this.plugins=[];
    	}else if(this$.refundFlag && !isNullOrEmpty(this$.refundFlag)){
	   		 columns=this$.getRefundColumnArray();    		     		 
			 tbarFields=this$.getRefundTbarFieldsArray();
			 tbarFields=tbarFields.concat(this$.getCommonTbarFieldsArray());
			 toolBar=this$.getMainToolBar(tbarFields);
			 this.plugins=[];
    	}
        
    	Ext.apply(this, {
    		store: store,
        	columns: columns,        	        	
        	dockedItems: toolBar
        });
        this.callParent(arguments);
        
        var custompagingtoolbar=this.down('custompagingtoolbar');
        if(custompagingtoolbar){
        	custompagingtoolbar.bindStore(store);
        }
        
        if(this$.refundFlag && !isNullOrEmpty(this$.refundFlag)){
	   		 this.down("#assignApplicationId").setVisible(false);
	   		 this.down("#makePayment").setVisible(false);	   		 
        }
    },
    columns: [],    
    
    
    /************************************* Main Toolbar *********************************************************/
    getMainToolBar:function(tbarFields){
    	var toolBarArray=new Array();
    	
    	var topToolbar={
                xtype: 'toolbar',
                dock: 'top',
                items: tbarFields    		
    	};
	    
    	var bottomToolbar={
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            displayInfo: true,
	            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')       
	        }]
	    };
    	
    	toolBarArray.push(topToolbar,bottomToolbar);
    	
    	return toolBarArray;
    },
    
    /********************************* Columns *************************************************/
    
    						/*************** Application Fee Columns ***********************************/
    getApplicationFeeColumnArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        header: getAdmissionTranslation('APPLICATION_ID'), //Application ID
	        dataIndex: 'applicationId',
	        flex: .2
	    }, {
	        header: getAdmissionTranslation('APPLICANT_NAME'), //Applicant Name
	        dataIndex: 'applicantName',
	        flex: .2
	    });
    	return itemArry;
    },
    					/*************** Submission Fee Columns *******************/
    getSubmissionFeeColumnArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        header: getAdmissionTranslation('APPLICATION_NO'), //Application ID
	        dataIndex: 'applicationId',
	        flex: .2
	    }, {
	        header: getAdmissionTranslation('APPLICANT_NAME'), //Applicant Name
	        dataIndex: 'applicantName',
	        flex: .2
	    });
    	return itemArry;
    },
    
    						/*************** Stage Fee Columns *******************/
    getStageFeeColumnArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        header: getAdmissionTranslation('APPLICATION_ID'), //Application ID
	        dataIndex: 'code',
	        flex: .2
	    }, {
	        header: getAdmissionTranslation('APPLICANT_NAME'), //Applicant Name
	        dataIndex: 'applicantName',
	        flex: .2
	    },{
            header: getAdmissionTranslation('ACADEMY'), //Academy 
            dataIndex: 'academyName',
            flex: .2
        }, {
            header: getAdmissionTranslation('LOCATION'), //Location
            dataIndex: 'locationName',
            flex: .2
        }, {
            header: getAdmissionTranslation('PROGRAM'), //Program
            dataIndex: 'programName',
            flex: .2
        }, {
            header: getAdmissionTranslation('BATCH'), //Batch
            dataIndex: 'batchName',
            flex: .2
        }, {
            header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
            dataIndex: 'seatTypeName',
            flex: .2
        },{
	        header: getAdmissionTranslation('CURRENT_STAGE'), //Current Stage
	        dataIndex: 'stageName',
	        flex: .2
	    },{
	        header: getAdmissionTranslation('FEE_AMOUNT'), //Fees Amount
	        dataIndex: 'feeAmount',
	        flex: .2
	    }, {
	        header: getAdmissionTranslation('FEE_PLAN'), //Fee Plan
	        dataIndex: 'feePlanName',
	        flex: .2
	    },{    
	        header: getAdmissionTranslation('BILL_NO'), //Bill No 
	        dataIndex: 'billNo',	        
	        flex: .2
	    }/*,{    
	        header: getAdmissionTranslation('RECEIPT_NO'), //Receipt No 
	        dataIndex: 'receiptNo',	
	        hidden:true,
	        flex: .2
	    }*/);
    	return itemArry;
    },
    
    									/*************** Refund  Columns *******************/
    getRefundColumnArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        header: getAdmissionTranslation('APPLICATION_ID'), //Application ID
	        dataIndex: 'applicationId',
	        flex: .2
	    }, {
	        header: getAdmissionTranslation('APPLICANT_NAME'), //Applicant Name
	        dataIndex: 'applicantName',
	        flex: .2
	    },{    
	        header: getAdmissionTranslation('EMAIL_ID'), //E-mail ID
	        dataIndex: 'email',
	        hidden:true,
	        flex: .2
	    }, {     
	        header: getAdmissionTranslation('PHONE_NUMBER'), //Phone Number
	        dataIndex: 'phoneNo',
	        hidden:true,     
	        flex: .2
	    });
    	return itemArry;
    },
    
    
    /********************************* Tbar Fields ****************************************/
    
									/************** Common Tbar Fields ***********************/
    getCommonTbarFieldsArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        xtype: 'button',
	        itemId: 'btnFindApplication',        
	        disabled:true,
	        tooltip: getAdmissionTranslation('SEARCH'), //Search
	        text: getAdmissionTranslation('SEARCH'),
	        //Search
	    },
	    {
	        xtype: 'button',
	        itemId: 'assignApplicationId', 
	        hidden:true,
	        tooltip: getAdmissionTranslation('ASSIGN_APP_ID'), //Assign Application ID
	        text: getAdmissionTranslation('ASSIGN_APP_ID'), //Assign Application ID
	    },{
	        xtype: 'button',
	        itemId: 'makePayment',        	        
	        tooltip: getAdmissionTranslation('COLLECT_PAYMENT'), //Make Payment
	        text: getAdmissionTranslation('COLLECT_PAYMENT'), //Make Payment
	    }
	    /*{
	        xtype: 'splitbutton',
	        text: getCommonTranslation('MORE_OPERATIONS'),
	        itemId: 'btnMoreOperations',
	        disabled:true,
	        tooltip: getCommonTranslation('MORE_OPERATIONS'),
	        menu: new Ext.menu.Menu({
	            items: [{
	                text: getAdmissionTranslation('ASSIGN_APP_ID'), //Assign Application ID
	                itemId: 'assignApplicationId'
	            },{
	                text: getAdmissionTranslation('MAKE_PAYMENT'), //Make Payment
	                itemId: 'makePayment'
	            },{
	                text: getAdmissionTranslation('PRINT_RECEIPT'), //Print Receipt
	                itemId: 'printReceipt'
	            }]
	        })
	    }*/
	    );
    	return itemArry;
    },
    
    
    							/************** Application Fee Tbar Fields ***********************/
    getApplicationFeeTbarFieldsArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        xtype: 'textfield',
	        itemId: 'txtTokenId',	       
	         //Token ID
	        fieldLabel: getAdmissionTranslation('TOKEN_ID') //Token ID
	    });
    	return itemArry;
    },
    
							/************** Submission Fee Tbar Fields ***********************/
    
    getSubmissionFeeExtraTbar:function(){    	    		 	     	
    	var tbarFields=new Array({
	        xtype: 'textfield',
	        itemId: 'txtReceiptNo',
	         //Receipt NO.
	        fieldLabel: getAdmissionTranslation('RECEIPT_NO') //Receipt NO.
	    });
    	tbarFields=tbarFields.concat(this.getCommonTbarFieldsArray());
    	var extraToolBar={
	                xtype: 'toolbar',
	                dock: 'top',
	                items: tbarFields
	    		};
	    return extraToolBar;
    },
    getSubmissionFeeTbarFieldsArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        xtype: 'textfield',
	        itemId: 'txtTokenId',	       
	         //Token ID
	        //fieldLabel: getAdmissionTranslation('TOKEN_IDD') //Token ID
	        fieldLabel: getAdmissionTranslation('FORM_NO') //Form No
	    },{
	        xtype: 'textfield',
	        itemId: 'txtApplicationId',	        
	         //Application Id
	        fieldLabel: getAdmissionTranslation('APPLICATION_NO') //Application Id
	    },{
	        xtype: 'textfield',
	        itemId: 'txtApplicantName',
	         //Applicant Name
	        fieldLabel: getAdmissionTranslation('APPLICANT_NAME'), //Applicant Name
	        style:{
    			'margin-right':'0px !important'
    		},
	    });
    	return itemArry;
    },
    
								/************** Stage Fee Tbar Fields ***********************/
    getStageFeeTbarFieldsArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        xtype: 'textfield',
	        itemId: 'txtApplicationId',	
	        labelWidth:96,
	         //Application Id
	        fieldLabel: getAdmissionTranslation('APPLICATION_ID') //Application Id
	    },{
	        xtype: 'textfield',
	        itemId: 'txtApplicantName',
	        labelWidth:110,
	         //Applicant Name
	        fieldLabel: getAdmissionTranslation('APPLICANT_NAME') //Applicant Name
	    },{
	        xtype: 'textfield',
	        itemId: 'txtReceiptNo',
	        labelWidth:80,
	         //Receipt NO.
	        fieldLabel: getAdmissionTranslation('RECEIPT_NO') //Receipt NO.
	    });
    	return itemArry;
    },
    
								/************** Refund  Tbar Fields ***********************/
    getRefundTbarFieldsArray:function(){
    	var itemArry=new Array();
	    itemArry.push({
	        xtype: 'textfield',
	        itemId: 'txtApplicationId',	        
	         //Application Id
	        labelWidth:96,
	        fieldLabel: getAdmissionTranslation('APPLICATION_ID') //Application Id
	    },{
	        xtype: 'textfield',
	        itemId: 'txtApplicantName',
	        labelWidth:110,
	         //Applicant Name
	        fieldLabel: getAdmissionTranslation('APPLICANT_NAME') //Applicant Name
	    },{
	        xtype: 'textfield',
	        itemId: 'txtReceiptNo',
	        labelWidth:80,
	        fieldLabel: getAdmissionTranslation('RECEIPT_NO') //Receipt NO.
	    },{
	        xtype: 'button',
	        itemId: 'btnProcessRefund',      
	        hidden:true,
	        tooltip: getAdmissionTranslation('PROCESS_REFUND'), // Process Refund
	        text: getAdmissionTranslation('PROCESS_REFUND') // Process Refund
	    });
    	return itemArry;
    }    
});