/**
 * This grid is used for the list of quotas in quota setting.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.quotas.QuotaGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.quotagrid',
    title: getAdmissionTranslation('QUOTAS_LIST'),
    border: true,
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},

    columns : [/*{
		xtype: 'rownumberer'
	},*//* {
        text: getCommonTranslation('ID'),
        dataIndex: 'id',
        hidden:true
    },*/{
        text: getAdmissionTranslation('DISPLAY_ORDER'),
        dataIndex: 'displayOrder',
        hidden:true
    }, {
        text: getAdmissionTranslation('QUOTA'),
        dataIndex: 'code',
        sortable: true
    }, {
        text: getAdmissionTranslation('DESCRIPTION'),
        dataIndex: 'quotaDescription',
        sortable: true,
        flex: 1
    },{
        xtype:'actioncolumn',
        text : getAdmissionTranslation('REORDER'),
        width:'auto',
        items: [{
        	xtype: 'button',
        	itemId: 'upButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-up',  // Use a URL in the icon config
            tooltip: 'UP',
            handler: function(grid, rowIndex, colIndex) {
            	if(rowIndex != 0) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var previousRecord = grid.getStore().getAt(rowIndex-1); 
	            	previousRecord.set('displayOrder', (previousRecord.get('displayOrder'))+1);
	            	//previousRecord.index = (previousRecord.index)+1;
	            	record.set('displayOrder', (record.get('displayOrder'))-1);
	            	//record.index = (record.index)-1;
	            	grid.getStore().sort();
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex-1, record);
                    grid.getStore().remove(previousRecord, true);
                    grid.getStore().insert(rowIndex, previousRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('UPERRORMESSAGE'));
            	}
            }
        },{
        	xtype: 'button',
        	itemId: 'downButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
            tooltip: 'DOWN',
            handler: function(grid, rowIndex, colIndex) {
            	lastRowIndex = grid.getStore().getCount()-1;
            	if(rowIndex != lastRowIndex) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var nextRecord = grid.getStore().getAt(rowIndex+1); 
	            	nextRecord.set('displayOrder', (nextRecord.get('displayOrder'))-1);
	            	//nextRecord.index = (nextRecord.index)-1;
	            	record.set('displayOrder', (record.get('displayOrder'))+1);
	            	//record.index = (record.index)+1;
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex+1, record);
                    grid.getStore().remove(nextRecord, true);
                    grid.getStore().insert(rowIndex, nextRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('DOWNERRORMESSAGE'));
            	}
            }
        }]
    }],

    plugins: [{
        ptype: 'rowexpander',
        rowBodyTpl: new Ext.XTemplate('<table style="border:1px solid black;width: 100%;">', '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('VALID_FROM') + '</th> <th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'
        		+ getAdmissionTranslation('VALID_TILL') + '</th> <th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getCommonTranslation('STATUS') 
        		+ '</th>',
		        		'<tpl for="quotaValidities">',
		        		'<tr> <td style="width:100px;text-align:center">{validFrom:this.dateFormatChange}</td> <td style="width:100px;text-align:center">{validTill:this.dateFormatChange}</td> <td style="width:100px;text-align:center">{status:this.formatChange}</td></tr>',
		        '</tpl>',
        	'</table>', {
            formatChange: function(inputValue) {
                var color = inputValue == true ? 'green' : 'red';
                var value = inputValue == true ? getCommonTranslation('ACTIVE') : getCommonTranslation('INACTIVE');
                return '<span style="color: ' + color + ';">' + value + '</span>';
            },
	        dateFormatChange: function(inputValue) {
	            return dateRender(inputValue);
	        }
        })
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add
        glyph: ICONGLYPH.ADDGLYPH,
        menu: Ext.menu.Menu({
            items: [{
                text: getAdmissionTranslation('QUOTA'),
                itemId: 'addQuota' 
            }, {
                text: getAdmissionTranslation('VALIDITY_PERIOD'),
                itemId: 'addValidityPeriod'
            }]
        })
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit
        glyph: ICONGLYPH.EDITGLYPH,
        menu: Ext.menu.Menu({
            items: [{
                text: getAdmissionTranslation('QUOTA'),
                itemId: 'editQuota'
            }, {
                text: getAdmissionTranslation('VALIDITY_PERIOD'),
                itemId: 'editValidityPeriod'
            }]
        })
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View
        iconCls: 'view-icon',
        menu: Ext.menu.Menu({
            items: [{
                text: getAdmissionTranslation('QUOTA'),
                itemId: 'viewQuota'
            }, {
                text: getAdmissionTranslation('VALIDITY_PERIOD'),
                itemId: 'viewValidityPeriod'
            }]
        })
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'), //Delete
        glyph: ICONGLYPH.DELETEGLYPH,
        menu: new Ext.menu.Menu({
            items: [{
                text: getAdmissionTranslation('QUOTA'),
                itemId: 'deleteQuota'
            }, {
                text: getAdmissionTranslation('VALIDITY_PERIOD'),
                itemId: 'deleteValidityPeriod'
            }]
        })
    }, {
        xtype: 'button',
        text:  getAdmissionTranslation('SAVE_REORDERING'),
        itemId: 'saveReordering',
        tooltip: getAdmissionTranslation('SAVE_REORDERING')
    }],
	
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.quotas.QuotaLists');
    },

});
