/**
 * @author Pravin.Surve
 *replace student search form
 */
Ext.define('Academia.view.admission.replacement.ReplaceStudentSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.replacestudentsearchform',
    frame: false,
    cls: 'customSearchPanel',
    height: '30%',
    defaults: {
        labelAlign: 'top'
    },
    layout: 'vbox',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'stageObject',
        name: 'stageObject'
    },{
        xtype: 'fieldcontainer',
        itemId: 'replaceAcadLocProgBatchContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('ACADEMY'),
            name: 'academyId',
            itemId: 'academyId',
            allowBlank: false,
            autoload: true,
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.AcademyByUserStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('LOCATION'),
            name: 'locationId',
            itemId: 'locationId',
            editable: false,
            allowBlank: false,
            disabled: true,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.LocationByUserStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('PROGRAM'),
            editable: false,
            disabled: true,
            allowBlank: false,
            name: 'programId',
            itemId: 'programId',
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'replaceSeattypeQuotaContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('BATCH'),
            editable: false,
            allowBlank: false,
            disabled: true,
            name: 'batchId',
            itemId: 'batchId',
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('SEAT_TYPE'),
            editable: false,
            allowBlank: false,
            disabled: true,
            name: 'seatTypeId',
            itemId: 'seatTypeId',
            valueField: 'seatTypeId',
            displayField: 'seatTypeName',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }
        }]}, {
            xtype: 'fieldcontainer',
            itemId: 'replaceQuotaContainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('QUOTA_TYPE'),
            editable: false,
            disabled: true,
            //allowBlank: false,
            name: 'quotaTypeId',
            itemId: 'quotaTypeId',
            displayField: 'code',
            valueField: 'id',
            queryMode: 'remote',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.selectionProcess.QuotaTypesByProgramBatchSeatConfigId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getAdmissionTranslation('QUOTA'),
            editable: false,
            //allowBlank: false,
            disabled: true,
            name: 'quotaId',
            itemId: 'quotaId',
            displayField: 'code',
            valueField: 'id',
            queryMode: 'remote',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.quotas.QuotaLists');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            formBind: true,
            text: getAdmissionTranslation('SEARCH'),
            itemId: 'searchBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'replaceStudentResetButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                	this.up('form').down('#locationId').setDisabled(true);
                	this.up('form').down('#programId').setDisabled(true);
                	this.up('form').down('#batchId').setDisabled(true);
                	this.up('form').down('#quotaTypeId').setDisabled(true);
                	this.up('form').down('#quotaId').setDisabled(true);
                	this.up('form').down('#seatTypeId').setDisabled(true);
                }
            }
		}]
    }]
});