/**
 * @author Rupesh.Agrawal
 */
Ext.define('Academia.view.admission.replacement.StartReplacementGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.startreplacementgrid',
    title: getAdmissionTranslation('START_REPLACEMENT'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   /* selModel:Ext.create('Ext.selection.CheckboxModel',{
		checkOnly: true,
	    mode: 'multi',
    	showHeaderCheckbox : false
    }),*/
    initComponent: function() {
    	var grid=this;                
    	var store=Ext.create('Academia.store.admission.replacement.ClosedReplacementStore');
    	var columns =new Array();
    	var columnArray=new Array();
    	var toolBarItems=new Array();
    	   	columnArray=columnArray.concat(grid.getFixedColumns());				    	   		    	   		
			columns=columnArray;
			toolBarItems=grid.getToolBarItems();
//			grid.selModel=Ext.create('Ext.selection.CheckboxModel',{
//    				checkOnly: true,
//    			    mode: 'single'
//    		  });
       
        this.doLayout();
        Ext.apply(this, {
            store: store,
            columns: columns,
            tbar:toolBarItems,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    displayInfo: true,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')      
                }]
            }]
        });
        this.callParent(arguments);
    },
    columns: [],
    
    getFixedColumns:function(){
    	var fixedColumns=[{
            header: getAdmissionTranslation('ACADEMY'), //Academy 
            dataIndex: 'academy.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('LOCATION'), //Location
            dataIndex: 'location.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('PROGRAM'), //Program
            dataIndex: 'program.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('BATCH'), //Batch
            dataIndex: 'batch.value',
            flex: .2,
            sortable: true
        }, {
            header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
            dataIndex: 'seatType.value',
            flex: .2,
            sortable: true
        }];
    	
    	return fixedColumns;
    },
    getToolBarItems:function(){
    	var items=[{
            xtype: 'button',
            text: getAdmissionTranslation('START_REPLACEMENT'), 
            itemId: 'startReplacementBtn',
            disabled: true
        }];
    	
    	return items;
    }  
});
