/**
 * This window is used for add/Edit/view of the Evaluation Parameters in the Evaluation Parameters
 * grid in the selection process.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.EvaluationParametersWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.evaluationparameterswindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    width: 342,
    title: getAdmissionTranslation('EVALUATION_PARAMETERS'),
    items: [{
        xtype: 'form',
        itemId: 'evalParamForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype : 'hidden',
        	name: 'version'
        },{
            xtype: 'textfield',
            name: 'evaluationParameter',
            fieldLabel: getAdmissionTranslation('EVALUATION_PARAMETER'), 
            allowBlank: false
        }, {
			xtype : 'numberfield',
			name : 'weightage',
			itemId: 'weightage',
			fieldLabel : getAdmissionTranslation('WEIGHTAGE'),// quota type
			allowBlank: false,
			minValue: 0,
			maxValue: 100,
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false

		}, {
			xtype : 'numberfield',
			name : 'maxMarks',
			itemId: 'maxMarks',
			fieldLabel : getAdmissionTranslation('MAXIMUM_MARKS'),
			allowBlank: false,
			minValue: 0,
			hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        validator : function(val) {
				var minValueField = Ext.ComponentQuery.query('numberfield#minMarks')[0];
				var minValue = minValueField.getValue();
				if (minValue != null) {
					if ((val > minValue || val == "") && minValue >=0) {
						minValueField.clearInvalid();
						return true;
					}
					else if(minValue < 0 && minValue >= val) {
						minValueField.markInvalid('The value should be less than of maximum marks </br> The value cannot be negative');
						return 'The value should be greater than of minimum marks';
					}
					else if(minValue < 0 && minValue < val) {
						minValueField.markInvalid('The value cannot be negative');
						return true;
					}
					else if(minValue >= val){
						minValueField.markInvalid('The value should be less than of maximum marks');
						return 'The value should be greater than of minimum marks';
					}
					
				} else {
					return true;
				}
			}

        },
        {
			xtype : 'numberfield',
			name : 'minMarks',
			itemId: 'minMarks',
			fieldLabel : getAdmissionTranslation('MINIMUM_MARKS'),
			minValue: 0,
			hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        validator : function(val) {
				var maxValueField = Ext.ComponentQuery.query('numberfield#maxMarks')[0];
				var maxValue = maxValueField.getValue();
				if (maxValue != null) {
					if ((val < maxValue || val == "") && maxValue >=0) {
						maxValueField.clearInvalid();
						return true;
					}
					else if(maxValue < 0 && maxValue <= val && val < 0) {
						maxValueField.markInvalid('The value should be greater than of minimum marks </br> The value cannot be negative');
						return 'The value should be less than of maximum marks';
					}
					else if(maxValue < 0 && maxValue > val) {
						maxValueField.markInvalid('The value cannot be negative');
						return true;
					}
					else if(maxValue <= val){
						maxValueField.markInvalid('The value should be greater than of minimum marks');
						return 'The value should be less than of maximum marks';
					}
				} else {
					return true;
				}
			}

        },{
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveEvaluationParameters',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});