/**
 * This Grid is used for Resource Requirement Grid in Resourse Plan tab of selection process
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.ResourceRequirementGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.resourcerequirementgrid',
	title : getAdmissionTranslation('RESOURCE_PLAN'),
	border : true,
	store: 'Academia.store.admission.selectionProcess.ResourceRequirements',
	
	columns : [ {
		text : getAdmissionTranslation('RESOURCE_GROUP'),
		dataIndex: 'resourceGroup',
		sortable : true,
		flex: .2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return record.data.resourceGroup;
			}
		}
	}, {
		text : getAdmissionTranslation('RESOURCE_CATEGORY'),
		dataIndex : 'resourceCategory',
		sortable : true,
		flex: .2,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return record.data.resourceCategory;
			}
		}
	}, {
		text : getAdmissionTranslation('RESOURCE_TYPE'),
		dataIndex : 'resourceTypes',
		sortable : true,
		flex: .2,
		renderer: function(obj) {
            return columnObjRender(obj, "value");
        }
	}, {
		text : getAdmissionTranslation('QUANTITY'),
		dataIndex : 'resourceQuantity',
		sortable : true,
		flex: .2
	}],
	
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	 emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
        	store: 'Academia.store.admission.selectionProcess.ResourceRequirements'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}]
});