/**
 * This Grid is used for Selection Process StagesGrid in Selection Process
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.SelectionProcessStagesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.selectionprocessstagesgrid',
    title : getAdmissionTranslation('SELECTION_PROCESS_STAGES'),
	border : true,
	store: 'Academia.store.admission.selectionProcess.SelectionProcessStages',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		xtype: 'rownumberer',
		hidden: true,
		flex:0.1
	},{
		text : getAdmissionTranslation('STAGE_NAME'),
		dataIndex: 'stageName',
		flex:0.1,
		sortable : false
	}, {
		text : getAdmissionTranslation('APPROVAL_REQUIRED'),
		dataIndex : 'committeeApprovalRequired',
		flex: 0.1,
		sortable : false,
		renderer: function(value){
			if(isNullOrEmpty(value)) {
				return getCommonTranslation('NO');
			} else {
				return getCommonTranslation('YES');
			}
		}
	}, {
		text :getAdmissionTranslation('GENERALREMARKS'),
		dataIndex : 'remark',
		flex: 0.1,
		sortable : false
	},{
        xtype:'actioncolumn',
        text : getAdmissionTranslation('REORDER'),
        flex: 0.1,
        sortable : false,
        items: [{
        	xtype: 'button',
        	itemId: 'upButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-up',  // Use a URL in the icon config
            tooltip: 'UP',
            handler: function(grid, rowIndex, colIndex) {
            	if(rowIndex != 0) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var previousRecord = grid.getStore().getAt(rowIndex-1); 
	            	previousRecord.set('stageOrder', (previousRecord.get('stageOrder'))+1);
	            	record.set('stageOrder', (record.get('stageOrder'))-1);
	            	grid.getStore().sort();
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex-1, record);
                    grid.getStore().remove(previousRecord, true);
                    grid.getStore().insert(rowIndex, previousRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('UPERRORMESSAGE'));
            	}
            }
        },{
        	xtype: 'button',
        	itemId: 'downButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
            tooltip: 'DOWN',
            handler: function(grid, rowIndex, colIndex) {
            	lastRowIndex = grid.getStore().getCount()-1;
            	if(rowIndex != lastRowIndex) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var nextRecord = grid.getStore().getAt(rowIndex+1); 
	            	nextRecord.set('stageOrder', (nextRecord.get('stageOrder'))-1);
	            	record.set('stageOrder', (record.get('stageOrder'))+1);
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex+1, record);
                    grid.getStore().remove(nextRecord, true);
                    grid.getStore().insert(rowIndex, nextRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('DOWNERRORMESSAGE'));
            	}
            }
        }]
	}],
	 
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
			store : 'Academia.store.admission.selectionProcess.SelectionProcessStages'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},/*{
		xtype : 'button',				
		itemId : 'configureStage',
		text: getAdmissionTranslation('CONFIGURE_STAGE'),
		tooltip :getAdmissionTranslation('CONFIGURE_STAGE')
	},{
		xtype : 'button',				
		itemId : 'saveReordering',
		text: getAdmissionTranslation('SAVE_REORDERING'),
		tooltip : getAdmissionTranslation('SAVE_REORDERING')
    }*/
	{
		xtype : 'splitbutton',
        itemId:'spBtnMoreActions',
        text : getCommonTranslation('MOREACTIONS'),
        menu:[{
            text:getAdmissionTranslation('CONFIGURE_STAGE'),
            itemId:'configureStage'
        },{
        	text : getAdmissionTranslation('SAVE_REORDERING'),
        	itemId:'saveReordering'
        }],
        listeners: {click: function() {this.showMenu();}}	
	}
	]
});
