/**
 * Pop-up window for selecting the seats from a quota to other quota.
 * @author akshay.kalbhor
 */
Ext.define('Academia.view.admission.selectionStage.TransferSeatsWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.transferseatswindow',
    title: getAdmissionTranslation('TRANSFER_SEATS'),
    modal: true,
    resizable: false,
    items: [{
        xtype: 'form',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'fieldcontainer',
            defaults: {
            	labelAlign: 'top',
            	allowBlank: false,
            	queryMode: 'local',
            	xtype: 'customcombobox',
                width: 256
            },
            layout: {
            	type: 'hbox'
            },
            items: [{
	            name: 'fromSeatTypeCombo',
	            itemId: 'fromSeatTypeCombo',
	            fieldLabel: getAdmissionTranslation('FROM_SEAT_TYPE'),
	            store: 'Academia.store.admission.selectionStage.SeatTypePickListFromTo',
	            displayField: 'value',
	            valueField: 'id',
	            listeners:{
	                'select': function(comboReference, records, eOpts) {
	                	var combo = this.up('form').down('customcombobox#fromQuotaCombo');
	                	combo.clearValue();
	            		combo.store.removeAll();
	                	var store = combo.getStore();
	                	var url = store.getProxy().proxyConfig.api.read;
	                	url = url.concat('?programSelectionProcessStageId=' +this.getValue());
	                	store.getProxy().api.read = url;
	                	store.load();
	                }
				}
            }, {
	            name: 'fromQuotaCombo',
	            itemId: 'fromQuotaCombo',
	            fieldLabel: getAdmissionTranslation('FROM_QUOTA'),
	            store: Ext.create('Academia.store.admission.selectionStage.MandatoryQuotas'),
	            displayField: 'value',
	            valueField: 'id'
            }]
        }, {
            xtype: 'fieldcontainer',
            defaults: {
            	xtype: 'customcombobox',
                labelAlign: 'top',
                allowBlank: false,
                queryMode: 'local',
                width: 256
            },
            layout: {
            	type: 'hbox'
            },
            items: [{
	            name: 'toSeatTypeCombo',
	            fieldLabel: getAdmissionTranslation('TO_SEAT_TYPE'),
	            store: 'Academia.store.admission.selectionStage.SeatTypePickListFromTo',
	            displayField: 'value',
	            valueField: 'id',
	            listeners:{
	                'select': function(comboReference, records, eOpts) {
	                	var combo = this.up('form').down('customcombobox#toQuotaCombo');
	                	combo.clearValue();
	            		combo.store.removeAll();
	                	var store = combo.getStore();
	                	var url = store.getProxy().proxyConfig.api.read;
	                	url = url.concat('?programSelectionProcessStageId=' +this.getValue());
	                	store.getProxy().api.read = url;
	                	store.load();
	                }
				}
            }, {
	            name: 'toQuotaCombo',
	            itemId: 'toQuotaCombo',
	            fieldLabel: getAdmissionTranslation('TO_QUOTA'),
	            store:  Ext.create('Academia.store.admission.selectionStage.MandatoryQuotas'),
	            displayField: 'value',
	            valueField: 'id'
            }]
        }, {
            xtype: 'numberfield',
            name: 'noOfSeatTransferred',
            width: 256,
            minValue: 1,
            fieldLabel: getAdmissionTranslation('SEATS_TO_TRANSFER'),
            allowBlank: false
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
            	xtype: 'button',
                itemId: 'windowAddColumn',
                text: getCommonTranslation('ADD'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]
});
