/**
 * 
 */

Ext.define('Academia.view.alumni.alumniCommon.AlumniDashboard', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumnidashboard',
    store: 'alumni.alumniCommon.AlumniDashboardStore',
    title: getAlumni('ALUMNI_LIST'),
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniCommon.AlumniDashboardStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: ['->', {
        xtype: 'button',
        itemId: 'resetPasswordId',
        tooltip: getAlumni('RESET_PASSPORT'),
        text: getAlumni('RESET_PASSPORT'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'deleteId',
        tooltip: getAlumni('DELETE'),
        text: getAlumni('DELETE'),
        disabled: true
    }],
    columns: [{
        header: getAlumni('ALUMNI_CODE'),
        dataIndex: 'alumniCode',
        flex: 1
    }, {
        header: getAlumni('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    },{
        header: getAlumni('ALUMNI_NAME'),
        dataIndex: 'alumniName',
        flex: 1,
        hidden: true
    }, {
        header: getAlumni('MIDDLE_NAME'),
        dataIndex: 'middleName',
        flex: 1,
        hidden: true
    }, {
        header: getAlumni('LAST_NAME'),
        dataIndex: 'lastName',
        flex: 1,
        hidden: true
    }, {
        header: getAlumni('PROGRAM_NAME'),
        dataIndex: 'programName',
        flex: 1,
        hidden: true
    }, {
        header: getAlumni('BATCH_NAME'),
        dataIndex: 'batchName',
        flex: 1,
        hidden: true
    },{
        header: getAlumni('EMAIL_ID'),
        dataIndex: 'emailId',
        flex: 1,
        hidden: true
    }, {
        header: getAlumni('MOBILE_NO'),
        dataIndex: 'mobileNo',
        flex: 1
    }, {
        header: getAlumni('DATE_OF_ADMISSION'),
        dataIndex: 'dateOfAdmission',
        flex: 1
    }, {
        header: getCommonTranslation('ADMISSION_INACTIVE'),
        dataIndex: 'admissionInactive',
        flex: 1
    }, {
        header: getCommonTranslation('DATE_OF_BIRTH'),
        dataIndex: 'dateOfBirth',
        flex: 1
    }, {
        header: getCommonTranslation('FATHER_NAME'),
        dataIndex: 'fatherName',
        flex: 1
    },{
        header: getCommonTranslation('MOTHER_NAME'),
        dataIndex: 'motherName',
        flex: 1
    },{
        header: getCommonTranslation('ADDRESS'),
        dataIndex: 'address',
        flex: 1
    }]
});
