/**
 *  @author Harshit Satya
 * 
 */
Ext.define('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.alumnifundsraisingfilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},		
        items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('TITLE'),
				name: 'title',
	            itemId: 'titleItemId',
	            minChars:3,
				forceSelection:true,
				store: 'alumni.alumniFundsRaising.AlumniFundsTitleStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'fundsTitle',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
	        },{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('FUND_ID'),
				name: 'fundsCode',
	            itemId: 'fundsCodeId',
	            minChars:3,
				forceSelection:true,
				store: 'alumni.alumniFundsRaising.AlumniFundsCodeStore',
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'fundsCode',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
				xtype: 'customcombobox',
				fieldLabel: getAlumni('STATUS'),
	            name: 'status',
	            itemId: 'statusItemId',
	            store: Ext.create('Academia.store.alumni.alumniList.AlumniStatusStore'),
				displayField: 'value',
		        valueField: 'value',
				forceSelection: true,
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}	
			}],			
    	},{
    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},	
    		items: [{
    		    xtype: 'datefield',
    		    fieldLabel: getAlumni('START_DATE'),
    		    name: 'startDate',
    		    itemId: 'startDateItemId',
    		    format: 'd/m/Y',
    		    valueField: 'id',
    		    displayField: 'value',
    		    renderer:function(val){        
    	            if(!isNullOrEmpty(val)){
    	                return dateRender(val);
    	            }
    	        },
    		    listeners: {
    		        change: function (field, newValue) {
    		            // Get the end date field
    		            var endDateField = field.up('form').down('#endDateItemId');
    		            // Set the minValue of the end date field to disable dates before start date
    		            if (newValue) {
    		                endDateField.setMinValue(newValue);
    		            } else {
    		                endDateField.setMinValue(null); // Clear the minValue if no start date is selected
    		            }
    		        }
    		    }
    		}, {
    		    xtype: 'datefield',
    		    fieldLabel: getAlumni('END_DATE'),
    		    name: 'endDate',
    		    itemId: 'endDateItemId',
    		    valueField: 'id',
    		    displayField: 'value',
    		    format: 'd/m/Y',
    		    renderer:function(val){        
    	            if(!isNullOrEmpty(val)){
    	                return dateRender(val);
    	            }
    	        },
    		    listeners: {
    		        change: function (field, newValue) {
    		            // Get the start date field
    		            var startDateField = field.up('form').down('#startDateItemId');
    		            // Validate end date
    		            if (newValue && startDateField.getValue() && newValue < startDateField.getValue()) {
    		                field.markInvalid(getAlumni('END_DATE_CANNOT_BE_BEFORE_START_DATE'));
    		            } else {
    		                field.clearInvalid();
    		            }
    		        }
    		    }
    		}]	
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'btnResetItemId',
    			name: 'btnReset',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}] 	
    	}]
});

