/**
 * Alumni Profile  
 * @author Amit.Gupta
 */
Ext.define('Academia.view.alumniSystem.alumniList.AlumniProfile', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.alumniprofile',
	cls: 'panelNoSpace',
	width: '100%',
	personId: '',
	autoScroll: false,
	personObj: {},
	style:{
		'top':'-12.5px !important'
	},
	layout: {
		type: 'border'
	},
	initComponent: function() {

		this.items = [{
			xtype: 'panel',
			region: 'center',
			cls: 'panelNoSpace',
			autoScroll: true,
			layout: {
				type: 'vbox'
			},
			items: [{
					xtype: 'panel',
					height:114,
					layout: {
						type: 'hbox'
					},
					style:{
					'border':'1px solid #e0e0e0;',
					'marginTop':'30px !Important',
					'border-radius': '5px;',
					'box-sizing': 'border-box',
					'box-shadow': '0px 2px 10px rgba(0, 0, 0, 0.1)',
					'border-radius': '4px'
					},
					width: '100%',
					//minWidth: 500,
					items: [ {
						xtype: 'panel',
						style: {
							marginTop: '0px !important'
						},
						layout: {
							type: 'hbox'
						},
						width: '100%',
						items: [{
							xtype:'image',
							itemId: 'profile_image',
							border: 1,
							style: {
								borderColor: '#e0e0e0',
								borderStyle: 'solid',
								borderRadius:'50%',
								marginTop: '25px !important',
								marginLeft: '13px !important'
							},
							width: 64,
							height: 64

						},{
							 	xtype: 'container', // Using container to manage custom HTML
							    itemId: 'alumni_profile_image_icon',
							    width: 50,
							    height: 50,
							    style: {
							        marginTop: '25px',
							        marginLeft: '13px',
							    },
							    html:'<span class="hoverElement" style="display: inline-block; width: 25px; height: 25px; border: 1px solid #e0e0e0; border-radius: 50%; overflow: hidden; padding: 5px; position: absolute; left: -32px; background-color: #fff; top: 35px;">' +
								    	'<img class="hoverImage" src="resources/images/Edit_Pro.svg" style="width: 100%; height: 100%; object-fit: cover;">' +
								    '</span>'
						},{
							xtype: 'panel',

							style: {
								marginTop: '25px !important',
								marginLeft: '20px !important',
							},
							width: '80%',
							height:100,
							items: [this.getAlumniProfileView()]
						}]
					}]
				
			}, {
				xtype: 'personinfopanel',
				itemId:'alumniPersonalInfoPanel',
				minWidth: 800,
				defaults: {
					border: false
				},
				listeners:{
					tabchange:function(tabpanel,newTab,oldTab){
						var grid = tabpanel.getActiveTab().down('grid');
						if(!isNullOrEmpty(grid)){
					//	grid.el.dom.style.opacity=0;
						setTimeout(function(){
							var structure = tabpanel.up('alumniprofile');
							var bodyScrollStructure = structure.down('[region=center]');
							if(!isNullOrEmpty(bodyScrollStructure.body)){
								bodyScrollStructure.body.scrollBy(0,1);
								bodyScrollStructure.body.scrollBy(0,-1);
								grid.el.dom.style.opacity=1;
							}
						 },100);
						}
					}
						
				}
			}]
		}, {
			xtype:'panel',
			width: '20%',
			region: 'east',
			layout:'vbox',
			cls: 'panelNoSpace',
			itemId: 'alumniProfileEastPanel',
			collapsible: true,
			border: true,
			defaults: {
				bodyStyle: 'padding:5px'
			},
			header:{
				layout:
			    {
			        type: 'hbox',
			        pack: 'end'
			    },
				items:[
					{
			        	xtype: 'combo',
			        	itemId: 'personalDetailLinkSearchComboBox',
			        	cls: 'searchComboBoxCls est_combo_cls',
			            store: Ext.create('Academia.view.personinfo.common.PersonDetailsLinkSearchStore'),
			            displayField: 'searchText',
			            valueField: 'menuId',
			            hideLabel: true,
			            width:'85%',
			            hideTrigger:true,
			        	enableKeyEvents: true,
			        	allowCollapse: false,
			        	minChars: 0,
			        	queryMode: 'local',
			        	emptyCls: 'search-empty-text-field',
			        	style: 'left:0 !important; top: 0 !important;',
			        	emptyText: getCommonTranslation('SEARCH'),
			        	anyMatch:    true,
			            listConfig: {
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_MATCH'),
			                cls: 'searchMenuListCls',
			                getInnerTpl: function() {
			                    return '<a class="searchItemCls">' +
			                        '<span class="displayPathCls" style="margin-left: 10px;">{displayPath}</span><span class="titleCls" style="left: 10px;">{title}</span>' +
			                    '</a>';
			                }
			            },
			            listeners: {
			            	select: function(combo, record){
			            		var parentPanelSelector = record[0].get('parentPanelSelector'),
			            			currentElementSelector = record[0].get('currentElementSelector'),
			            			currentItemIndex = record[0].get('currentItemIndex');
			            		
			            		Ext.getCmp(parentPanelSelector).up().expand();
			            		if(Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector).length == 0) {
			            			setTimeout(function(){
			            				Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            			},500);
			            		}
			            		else {
				            		Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            		}
			            		combo.clearValue();
			            	},
			            	beforequery: function(record){  //Added for sorting & any match
			            		this.getStore().sort([{
			                    	property : 'title',
			                    	direction: 'ASC'
			                    }]);
			                }
			            }
			        }
				]
			},
			hideHeaders : false,
			animate : true,
			animCollapse: true,
			titleCollapse : true,
			items:[{
				xtype: 'alumnidetailslinkpanel',
				flex: 1,
				collapsible: false,
				width:'100%',
				itemId : 'alumniPersonDetailsLinkPanel',
				border:false,
				cls: 'panelNoSpace'
			}]
		}];

		this.callParent(arguments);
	},
	getAlumniProfileView: function() {
		var alumniProfile = new Ext.XTemplate('<tpl for="."><div>', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				 '<tr style = "line-height: 33px;">',
                 '<th style ="font-weight: 700;width:20%;text-align: left;">Alumni ID</th>',
                 '<th style ="font-weight: 700;width:23%;text-align: left;">Alumni Name</th>',
                 '<th style ="font-weight: 700;width:23%;text-align: left;">Mobile No.</th>',
                 '<th style ="font-weight: 700;width:38%;text-align: left;">Email ID</th>',
                 '<th style ="font-weight: 700;width:20%;text-align: left;">Status</th>',
               '</tr>',
               '<tr>', 
				'<td style ="text-align: left;width:20%;">','<div>',
				'<span>{alumniUser.alumniCode}</span></div></td>',
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/student_profileIcon_trans.svg" style="width:16px;height:19px;position: absolute;">',
				'<span style ="margin-left: 21px;font-weight: 400;overflow: hidden;text-overflow: ellipsis;display: inline-block;width: 125px;white-space: nowrap;">{firstName} {middleName} {lastName}</span></div></td>', 
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/call_Icon_trans.svg" style="width:16px;height:19px;position: absolute;">',
				'<span style ="font-weight: 400;margin-left: 21px;"><tpl if="mobileCountryCode != null">{mobileCountryCode}-</tpl><tpl if="mobileNumber != null">{mobileNumber}</tpl></span></div></td>',
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/email_Icon_trans.svg" style="width:16px;height:19px;position: absolute;">',
				'<span style ="margin-left: 21px;font-weight: 400;">{emailId}</span></div></td>',
				
				'<tpl if="this.isActive(whetherActive.value)">',
				'<td <span style="color:#12bc34; margin-left : 7px; font-size : 13px"><strong>Active</strong></span></td>',
				'<tpl else>',
				'<td <span style="color:#de5a63; margin-left : 7px; font-size : 13px"><strong>Inactive</strong></span></td>', 
				'</tpl>',
				'</tr>', 
		'</table></div></tpl>',
				
				{
					isActive: function(status){
						return status=="Active";
					}
				}
		);
		var alumniProfileView={
				xtype: 'dataview',
				alias: 'widget.alumniprofileview',
				itemId: 'alumniProfileView',
				width: '100%',
				store: Ext.create('Academia.store.alumni.alumniList.AlumniProfileDataStore'),
				tpl: alumniProfile,
				itemSelector: 'div.thumb-wrap'
		};

		return alumniProfileView;
	},
});
