/**
 * @author Nikelsh
 * Photo upload form for alumni
 */
Ext.define('Academia.view.alumniSystem.alumniList.PhotoUploadForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.photouploadform',
    border: false,
    frame: false,
    cls: 'panelNoSpace',
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'filefield',
        fieldLabel: getPersonModuleTranslation('UPLOAD_LOGO'),
        buttonText: getPersonModuleTranslation('UPLOAD'),
        itemId: 'photoFileImage',
        ui: 'CustomBtnSubmit',
        cls:'CustomBtnSubmitToolbaar',
        name: 'file'
    }, {
    	xtype: 'button',
    	text: '',
    	itemId: 'evidenceLink',
    	hidden: true,
    	cls: 'hyperlinkBtn CustomBtnSubmitToolbaar',
    	handler: function(btn) {
    		var a = document.createElement('a');
			a.href = btn.href;
			var fileExtension = btn.fileExtension;
			a.download = btn.text.replaceAll(" ","_")+"."+fileExtension;
			document.body.appendChild(a);
			a.click();
			document.body.removeChild(a);
    	}
    }]
});