Ext.define('Academia.view.alumniSystem.alumniPortalSetUp.AlumniPortalConfigurationGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.alumniPortalConfigurationGrid',	
	store:'alumni.alumniPortalSetUp.AlumniPortalSetUpConfigGridStore', 
	//border: true,
	title:getAlumni('ALUMNI_PORTAL_CONFIGURATION'),
	autoScroll: false,
	//refreshStoreData:true,
	frame:false,
	style: {
		'position': 'relative !important'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getAlumni('SAVE'),
		action:'save',
		itemId:'btnSavePrivilege'
	}],	
	columns:[{
		header:getAlumni('MODULE_NAME'),
		dataIndex:'moduleName',
		flex:0.1,
		sortable:false,		
	},{
		xtype:'checkcolumn',
		header:getAlumni('MODULE_VISIBILITY'),
		flex:.1,
		sortable:false,
		dataIndex : 'visibility',
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleCode != 'STEP1_DASHBOARD' && data.moduleCode != 'STEP2_MYPROFILE' && data.moduleCode != 'STEP8_PERSONAL_INFORMATION' && data.moduleCode != 'STEP9_PROFESSIONAL_INFORMATION'
				&& data.moduleCode != 'STEP10_EDUCATION_DETAIL' && data.moduleCode != 'STEP11_ADDRESS' && data.moduleCode !='STEP12_NOTIFICATIONS'){
				var cssPrefix = Ext.baseCSSPrefix,
				cls = cssPrefix + 'grid-checkcolumn';
				if (value) {
					cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
				}
				return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		}	
	},{
		header:getAlumni('MODULE_SEQUENCE'),
		flex:.05,
		sortable:false,
		dataIndex : 'sequenceNo',
		style: {
			'text-align': 'center'
		},
		editor: {
			xtype: 'numberfield',
			name: 'sequenceNo',
			minValue:0,
			maxValue:25,
			maxLength: 11,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: true,
			mouseWheelEnabled: false,
			allowDecimals:false,
			style: {
				margin: 'auto'
			},
			itemId: 'sequenceNoItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			var data=record.data;
			if(data.moduleCode != 'STEP1_DASHBOARD' && data.moduleCode != 'STEP2_MYPROFILE' && data.moduleCode != 'STEP8_PERSONAL_INFORMATION' && data.moduleCode != 'STEP9_PROFESSIONAL_INFORMATION'
				&& data.moduleCode != 'STEP10_EDUCATION_DETAIL' && data.moduleCode != 'STEP11_ADDRESS' && data.moduleCode != 'STEP12_NOTIFICATIONS'){
				if(!isNullOrEmpty(value) && value !== '') {
					try{
						rec.tdCls = 'gridInputCustomStyleForSqeuence';
						return value;
					}
					catch(e){
						return null;
					}
				}
				else {
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return getAlumni('CLICK_TO_ENTER');
				}
			}
		},
		enableKeyEvents: true,
		listeners: {
			blur: function(cmp) {
				if(cmp.isChanged){
				var record = cmp.newRecord;
				var newStore = cmp.up('grid').getStore();
				var storedata = cmp.up('grid').getStore().data.items;
				var sequenceNumber = record.get('sequenceNo');
				var value = cmp.getValue();
				
				if(Ext.isEmpty(value)) {
					record.set('sequenceNo', '');
				}
				storedata.forEach(function(obj){
					if(obj.get('id') != record.get('id') && obj.data['sequenceNo'] && obj.data['sequenceNo'] ==value){
						showWarningMessage(getAlumni('ALERT'), getAlumni('SEQUENCE_ALREADY_EXIST'));
						Ext.defer(function() {
							record= newStore.findRecord('id',record.get('id'));
							if(record.modified && record.modified.sequence){
								record.set('sequenceNo', record.modified.sequence);
							}else{
								record.set('sequenceNo', '');
							}
							
							record.resumeEvent('blur');
						}, 10)
						return;
					}
				});
				cmp.isChanged=false;
				}
			},
		}
	},{
		header:getAlumni('ADDITIONAL_SETUP'),
		sortable:false,
		dataIndex:'additionalSetUp',
		flex:0.1,
		renderer : function(value, rec, record, rowIndex, colIndex, store, view){		
			var data=record.data;
			if (data.moduleCode != 'STEP1_DASHBOARD' && data.moduleCode != 'STEP2_MYPROFILE' && data.moduleCode != 'STEP12_NOTIFICATIONS') {
				if(!isNullOrEmpty(record.data.alumniPortalSetupId)){
					return  '<a href="#">'+"Setup"+'</a>';
				}else{
					return 'Setup';
				}
			}
		}
	}],
	plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1,
    },
    listeners: {
		beforeedit: function(editor, context) {
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleCode == 'STEP1_DASHBOARD'){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 2;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleCode == 'STEP2_MYPROFILE'){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 2;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleCode == 'STEP8_PERSONAL_DETAIL'){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 2;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleCode == 'STEP9_PROFESSIONAL_DETAIL'){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 2;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleCode == 'STEP10_EDUCATIONAL_DETAIL'){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 2;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}
			if(editor.context.field=='sequenceNo'){
				if(context.record.data.moduleCode == 'STEP11_ADDRESS'){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 2;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}
		},
		change:function(cmp){
		cmp.newRecord = cmp.up('grid').getSelectionModel().getSelection()[0];
		cmp.isChanged=true;
	},
	keypress: function (field, e) {
        // Prevent input if not a number (keyCode 48-57 for numbers 0-9)
        // or not backspace (keyCode 8), delete (keyCode 46)
        if (e.getKey() < 48 || e.getKey() > 57) {
            e.preventDefault();
        }
    }

	}
}
);