/**
 *  @author Niklesh T
 * 
 */
Ext.define('Academia.view.alumniSystem.alumniPortalSetUp.AlumniPortalSetUpFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.alumniPortalSetUpFilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},		
        items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('ALUMNI_SETUP_NAME'),
				name: 'alumniId',
				itemId:'alumniItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.alumniPortalSetUp.AlumniSetupNameStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'setupName',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
	        },{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('CREATED_BY'),
				name:'createdBy',
				itemId:'createdByItemId',
				forceSelection: true,
				minChars:3,
				store: 'alumni.alumniPortalSetUp.AlumniCreatedUserStore',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'userName',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
				},
				{
					xtype : 'customcombobox',
					fieldLabel : getAlumni('ACADEMY_LOCATION'),		
					name : 'academyLocation',
					itemId : 'academyLocationItemId',
					minChars:3,
					forceSelection:true,
					store: 'alumni.alumniPortalSetUp.AlumniPortalSetUpAlStore',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'qry',
					listConfig: {
						listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getAlumni('SEARCHING'),
	    				emptyText: getAlumni('NO_RECORDS_FOUND'),
	    			}
				}
				],			
    	},{
    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},	
    		items : [
    			{
	    				xtype: 'datefield',
	    				fieldLabel:getAlumni('CREATION_FROM_DATE'),
	    				name:'createdStartDate',
	    				itemId:'createdDateStartItemId',
//	    				format: 'DD/MM/YYYY',
	    				vtype: 'daterange',
	    				endDateField: 'createdDateEndItemId',
	    				listeners: {
    						render: function(field) {
                        		return dateFormatRender(field);
                        	},
        				},	
					},{
						xtype: 'datefield',
						fieldLabel:getAlumni('CREATION_TO_DATE'),
						name:'createdEndDate',
						itemId:'createdDateEndItemId',
						forceSelection: true,
						vtype: 'daterange',
						startDateField: 'createdDateStartItemId',
						queryParam:'alumniCode',
//						format: 'DD/MM/YYYY',
						listeners: {
							render: function(field) {
	                    		return dateFormatRender(field);
	                    	},
	    				}
					}
				]
    		
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			style:{'margin-bottom':'10px !important'},
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			style:{'margin-bottom':'10px !important'},
    			name: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]
});

