/**
 * @author Niklesh Tiwane
 * 
 */
Ext.define('Academia.view.alumniSystem.alumniUploadDownloadStructure.AlumniDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.alumnidownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	width:'auto',
	height:'auto',
	items : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{		
            xtype: 'customcombobox',
            fieldLabel: getAlumni('ACADEMY_LOCATION'),
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationCombo',
            editable: true,
            store:Ext.create('Academia.store.user.UserAcademyLocationStore'),
            valueField: 'id',
            displayField: 'value',
            width:410,
            matchFieldWidth:true,
            allowBlank:false,
            minChars:3,
            typeAhead:true,
            forceSelection :true,
            queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        
		}]
		}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			layout: 'hbox',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		style: {
    			'margin-left': '-32px !important;'
    		},
			items : [{
				xtype: 'button',
				text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
				itemId: 'downoladBtnId',
				hidden:false,
				disabled:true,
				ui: 'CustomBtnSubmit'
			}]
		}]
});
