/**
 * @author Amandeep Bhatia
 */
Ext.define('Academia.view.applicantportalsetup.PaymentAdditionalSetup', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.paymentadditionalsetup',
    standardSubmit: false,
    layout: {
        type: 'vbox'
    },   
    items: [{
        xtype: 'form',
        itemId: 'PaymentAdditionalSetupItemId',
        frame: true,
        width: '100%',
        defaults: {
			labelAlign: 'top',
			width: 500
		},
        layout: {
			type: 'vbox'
		},
        items: [{
			xtype: 'hidden',
			name: 'id',
			itemId: 'Id'
		},
		{
			xtype: 'radiogroup',
			labelAlign:'top',
			itemId:'feeApplicableTypeId',
			name:'feeApplicableType',
			style:{
				color:'#2e2e2e',
				font:'normal 13px !important'
			},
			defaults: {
				 flex: 1
			 },
			items:[
			       { 
			    	 boxLabel: getFeeAndPaymentCommonTranslation('ONE_TIME_FEE'), 
			    	 name: 'feeApplicableType',
			    	 width:300,
			    	 height:30,
			    	 inputValue: 'true',
			    	 checked : true
			       },
			       { 
			    	 boxLabel: getFeeAndPaymentCommonTranslation('PROGRAM_WISE_FEE'),
			         name: 'feeApplicableType', 
			         width:300,
			    	 height:40,
			         inputValue: 'false'
			         }]
		},
		{
			xtype: 'textarea',
			name: 'declarations',
			itemId: 'declarationsItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('NOTES_DECLARATIONS'),
			width:500,
			autoScroll: true,
			maxLength:5000,
			style: {
				marginLeft: '10px',
			},

		},{
			xtype: 'textarea',
			name: 'InsGuideInOtherLang',
			itemId: 'InsGuideInOtherLang',
			fieldLabel: getHostelTranslation('INSTRUCTIONS_GUIDELINES_IN_OTHEER_LANG'),
			width:500,
			autoScroll: true,
			maxLength:5000,
			style: {
				marginLeft: '10px',
			},
		},{	
			xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			labelAlign: 'top',
    			width: 256
    		},items: [{
    			xtype: 'uploaddocumentlist',
    			itemId: 'uploaddocumentlistId',
    			width: 500
    		}]
    	},
		{
			xtype:'fieldcontainer',
			width:'auto',
			style: {
	          marginTop: '15px',
				marginLeft: '10px'
	        },
			items: [{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SaveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
    }]
    
   
});