/**
 * Amit
*/
var courseWiseStore = Ext.create('Academia.store.attendance.ConsolidateAttendanceTotalStudentGridStore');
Ext.define('Academia.view.attendance.ConsolidateAttendanceTotalStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.consolidateattendancetotalstudentgrid',
	store : courseWiseStore,
	title : getProgramandcourseTranslation('DAILY_ATTENDANCE_SUMMARY'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemid:'dockedItemsItemId',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			store : courseWiseStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

	},
	
	columns : [{
		header :getProgramandcourseTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'attendanceStatus',
		flex : 1,
		sortable : true
	}]
});
