/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.attendance.DownloadCourseLevelAttendanceCBSForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadcourselevelattendancecbsform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top'
		},
		items : [{    
			xtype: 'customcombobox',
			name:'ALL_COURSE_ID',
			itemId: 'allCourseId',
			width: 256,
			queryMode : 'local',
			anyMatch: true,
		    //store:'coursetransaction.sectionmanagement.CoruseSectionStore',
			store : Ext.create('Academia.store.attendance.AssignedCoursesFacultyBySectionTypeStore'),
			displayField : 'courseCodeName',
			valueField : 'courseId',
			fieldLabel:getCourseTxCommonTranslation('COURSE'),
			allowBlank:false,
			typeAhead:false,
			forceSelection:true
		 
		},{
			xtype: 'customcombobox',
			name:'ALL_COMPONENT_ID',
			itemId: 'componentSectionItemId',
			width: 256,
			queryMode : 'local',
			store:Ext.create('Academia.store.course.coursetopic.CourseComponentStore'),
			displayField: 'value',
			valueField: 'id',
			fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
			typeAhead:false,
			forceSelection:true,
			allowBlank:false,
			hidden:true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariant',
			itemId : 'courseVariantId',
			store:Ext.create('Academia.store.coursetransaction.homework.CourseVarientByCourseIdDropDown'),
			displayField : 'code',
			valueField : 'id',
			width: 256,
			queryMode : 'local',
			typeAhead : false,
			forceSelection : true,
			allowBlank:false,
			hidden:true,
	        disabled:true
		}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items :[{
				xtype: 'customcombobox',
				name:'ALL_SECTION_ID',
				itemId: 'courseSectionId',
				width: 256,
				queryMode : 'local',
			    store:Ext.create('Academia.store.attendance.SectionByVariant'),
				displayField: 'value',
				valueField: 'id',
				fieldLabel:getCourseTxCommonTranslation('SECTION'),
				allowBlank:false,
				typeAhead:false,
				disabled:true,
				forceSelection:true
		     },{
		    	xtype: 'customcombobox',
		        itemId: 'facultyId',
		        width: 256,
				queryMode : 'local',
		        name: 'COURSE_FACULTY_ID',
		        fieldLabel: getCourseTxCommonTranslation('FACULTY'),
		        store:Ext.create('Academia.store.coursetransaction.facultytopicassignment.AssignFacultyStore'),
		        displayField: 'value',
		        valueField: 'id',
		        allowBlank: false,
		        typeAhead: false,
		        disabled:true,
		        forceSelection: true
		    }]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			style: {
				'margin-left': '-42px !important;'
			},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'downoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
	            xtype: 'button',
	            text: getCourseTxCommonTranslation('RESET'),
	            itemId: 'resetBtn',
	            buttonAlign: 'left',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		}]					
});
