/**
 * @author Prashant choudhary
 */
Ext.define('Academia.view.attendance.DownloadServiceLevelAttendanceForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadservicelevelattendanceform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'service',
				itemId:'serviceId',
				fieldLabel : getProgramandcourseTranslation('SERVICE'),
				allowBlank: false,
				disabled:false,
				width: 256,
				store: 'attendance.ServiceStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'serviceprogram',
				itemId : 'serviceProgramId',
				store : 'common.ServiceMappedProgram',
				displayField:'valueCode',
				valueField:'id',
				width: 536,
				allowBlank:true,
				disabled:true,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items :[{
				xtype: 'customcombobox',
				name : 'serviceprogramBatch',
				itemId : 'serviceProgramBatchId',
				store: 'attendance.BatchByServiceStore',
				disabled:true,
				width: 256,
				typeAhead:true,
				displayField: 'value',
				valueField: 'id',
				queryMode: 'local',
				fieldLabel: getCommonTranslation('BATCH'),
				allowBlank: false,
			},{
				xtype : 'datefield',
				width: 256,
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'dateOfAttendance',
				itemId:'dateOfAttendance_Id',
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				allowBlank: false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setMaxValue(new Date());						
						obj.setValue(new Date());
					}
				}
			},{
				xtype : 'datefield',
				width: 256,
				fieldLabel :getProgramandcourseTranslation('TO_DATE'),
				name : 'consolidateEndDate',
				itemId : 'consolidateEndDate_Id',
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				allowBlank: false,
				maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);	
						obj.setMaxValue(new Date());						
						obj.setValue(new Date());
					}	
				}
			}]},
			{
				xtype: 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
	    		cls: 'customSearchPanelBtnsFieldContainerCls markAttendanceBtnCls',
				items: [{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'downoladBtnId',
					formBind : true,
					ui: 'CustomBtnSubmit'
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});
