/**
 * Abhishek Bais
 * 
 */
Ext.define('Academia.view.attendance.SessionWiseDailyAttendanceSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.sessionwisedailyattendancesearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,

		},
		{
			xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'ProgramGroupItemId',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore'),
			editable: true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			typeAhead:false,

		}]
	},
	{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'section',
			itemId : 'sectionItemId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width: 536,
			triggerAction: 'all',
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			typeAhead:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}


		}]
	},
	{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'programWiseStartDate',
			itemId:'programWiseStartDate',
			endDateField : 'programWiseEndDate',
			format : CONSTANTS.DATE_FORMAT,
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date()
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'programWiseEndDate',
			itemId : 'programWiseEndDate',
			startDateField : 'programWiseStartDate',
			format : CONSTANTS.DATE_FORMAT,
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date()

		}
		]},
		{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				 width: 256,
				fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
				name:'sessionNo',
				itemId: 'sessionItemId',
				displayField: 'val',
				valueField: 'code',
				allowBlank:true,
				value:1,
				queryMode:'local',
				forceSelection:true
			}]
		},
		{
			xtype: 'fieldcontainer',
			width: '100%',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE	        				
			}]
		}
		]
});
