
var PendingAttendanceGridStore = Ext.create('Academia.store.attendance.PendingAttendanceGridStore');

Ext.define('Academia.view.attendance.pendingattendance.PendingAttendanceCourseWiseReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pendingattendancecoursewisereportgrid',
	store: PendingAttendanceGridStore,
	title : getProgramandcourseTranslation('PENDING_ATTENDANCE_REPORT'),
	border: true,
	refreshStoreData:true,
	deferEmptyText: false,
	//emptyText: getCommonTranslation('EMPTY_MESSAGE'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	tbar:[],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		itemId:'dockedItemsItemId',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
	          store: PendingAttendanceGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVaraintName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TOTAL_DAYS'),
		dataIndex : 'totalSession',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ATTENDANCE_MARKED'),
		dataIndex : 'totalMarkedAttendance',
		sortable : true,
		flex : 1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('ATTENDANCE_PENDING'),
		dataIndex : 'totalPendings',
		sortable : true,
		flex : 1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]

});
